/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer;

import com.ibm.es.nuvo.tokenizer.ReadableTToken;
import java.util.EnumSet;
import org.apache.lucene.index.Payload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TToken
implements ReadableTToken {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String toStringResult;
    private final Type type;
    private EnumSet<Property> props;
    protected byte[] payload;
    protected int positionIncrement;
    private static final TToken TOKEN_WHITESPACE = new NullToken(Type.WHITESPACE);
    private static final TToken TOKEN_SENTENCE = new NullToken(Type.SENTENCE);

    TToken(Type type) {
        this.type = type;
        this.props = null;
    }

    @Override
    public int getPositionIncrement() {
        return this.positionIncrement;
    }

    public void setPositionIncrement(int increment) {
        this.positionIncrement = increment;
    }

    byte[] getPayload() {
        return this.payload;
    }

    @Override
    public Payload getLucenePayload() {
        if (this.payload == null) {
            return null;
        }
        return new Payload(this.payload);
    }

    void setPayload(byte[] newPayload) {
        this.payload = newPayload;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new SubToken(this, start, end);
    }

    @Override
    public String toString() {
        if (this.toStringResult == null) {
            int len = this.length();
            StringBuffer buf = new StringBuffer(len);
            for (int i = 0; i < len; ++i) {
                buf.append(this.charAt(i));
            }
            this.toStringResult = buf.toString();
        }
        return this.toStringResult;
    }

    @Override
    public final Type getType() {
        return this.type;
    }

    public final EnumSet<Property> getProperties() {
        if (this.props == null) {
            this.props = EnumSet.noneOf(Property.class);
        }
        return this.props;
    }

    public final void addProperty(Property prop) {
        this.getProperties().add(prop);
    }

    public static final TToken newToken(CharSequence sequence, int begin, int end, Type type) {
        return new TokenCharSequence(sequence, begin, end, type);
    }

    public static final TToken newToken(char[] text, int begin, int end, Type type) {
        return new TokenCharArray(text, begin, end, type);
    }

    public static final TToken newToken(CharSequence text, Type type) {
        if (text == null) {
            throw new NullPointerException();
        }
        return new TokenCharSequence(text, 0, text.length(), type);
    }

    public static final TToken newSentenceBreak() {
        return TOKEN_SENTENCE;
    }

    public static final TToken newWhitespace() {
        return TOKEN_WHITESPACE;
    }

    public static final TToken newHeaderToken(int version, byte[] header) {
        return new HeaderToken(version, header);
    }

    private static final class HeaderToken
    extends TToken {
        private HeaderToken(int version, byte[] headerbytes) {
            super(Type.HEADER);
            this.setPositionIncrement(version);
            this.setPayload(headerbytes);
        }

        public char charAt(int index) {
            throw new IndexOutOfBoundsException("Header doesn't have character string.");
        }

        public int length() {
            return 0;
        }
    }

    private static final class NullToken
    extends TToken {
        private NullToken(Type type) {
            super(type);
        }

        public int length() {
            return 0;
        }

        public char charAt(int index) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class SubToken
    extends TToken {
        private final TToken token;
        private final int start;
        private final int length;

        private SubToken(TToken token, int start, int end) {
            super(token.type);
            this.token = token;
            this.start = start;
            this.length = end - start;
        }

        public int length() {
            return this.length;
        }

        public char charAt(int i) {
            return this.token.charAt(this.start + i);
        }
    }

    private static final class TokenCharSequence
    extends TToken {
        private final CharSequence sequence;
        private final int begin;
        private final int length;

        private TokenCharSequence(CharSequence sequence, int begin, int end, Type type) {
            super(type);
            if (sequence == null) {
                throw new NullPointerException();
            }
            if (sequence.length() < end || end < begin) {
                throw new IndexOutOfBoundsException();
            }
            this.sequence = sequence;
            this.begin = begin;
            this.length = end - begin;
        }

        public char charAt(int i) {
            return this.sequence.charAt(this.begin + i);
        }

        public int length() {
            return this.length;
        }
    }

    private static final class TokenCharArray
    extends TToken {
        private final char[] text;
        private final int begin;
        private final int length;

        TokenCharArray(char[] text, int begin, int end, Type type) {
            super(type);
            if (text == null) {
                throw new NullPointerException();
            }
            if (text.length < end || end < begin) {
                throw new IndexOutOfBoundsException();
            }
            this.text = text;
            this.begin = begin;
            this.length = end - begin;
        }

        public char charAt(int i) {
            return this.text[this.begin + i];
        }

        public int length() {
            return this.length;
        }
    }

    public static class Type {
        final String typeStr;
        final int type;
        private static final int TYPE_HEADER = 0;
        private static final int TYPE_LEMMA = 2;
        private static final int TYPE_ORIGINAL = 1;
        private static final int TYPE_BOTH = 3;
        private static final int TYPE_PUNCTUATION = 4;
        private static final int TYPE_SENTENCE = 5;
        private static final int TYPE_NGRAM = 6;
        private static final int TYPE_GENERIC = 7;
        static final int ATTR_WHITESPACE = 128;
        static final int ATTR_METADATA = 64;
        static final int ATTR_PAYLOAD = 32;
        static final int MASK_TYPE = 15;
        static final int MASK_ATTR = 240;
        static final int MASK_ALL = 255;
        public static final Type HEADER = new Type("H", 0);
        public static final Type LEMMA = new Type("L", 2);
        public static final Type ORIGINAL = new Type("O", 1);
        public static final Type BOTH = new Type("B", 3);
        public static final Type PUNCTUATION = new Type("P", 4);
        public static final Type SENTENCE = new Type("S", 5);
        public static final Type NGRAM = new Type("N", 6);
        public static final Type GENERIC = new Type("G", 7);
        public static final Type WHITESPACE = new Type("W", 128);

        private Type(String type, int internalType) {
            this.typeStr = type;
            this.type = internalType;
        }

        public boolean equals(String t) {
            if (t == null || t.length() != 1) {
                return false;
            }
            return this.typeStr.charAt(0) == t.charAt(0);
        }

        public String toString() {
            return this.typeStr;
        }

        static Type getType(int type) {
            switch (type & 0xF) {
                case 2: {
                    return LEMMA;
                }
                case 1: {
                    return ORIGINAL;
                }
                case 3: {
                    return BOTH;
                }
                case 4: {
                    return PUNCTUATION;
                }
                case 5: {
                    return SENTENCE;
                }
                case 6: {
                    return NGRAM;
                }
                case 7: {
                    return GENERIC;
                }
                case 0: {
                    return HEADER;
                }
            }
            throw new IllegalAccessError();
        }

        boolean hasAttribute(int attrs) {
            return (this.type & attrs & 0xF0) == (this.type & 0xF0);
        }

        public static Type getTType(String tokenType) {
            if (tokenType.length() > 0) {
                char c = tokenType.charAt(0);
                switch (c) {
                    case 'B': {
                        return BOTH;
                    }
                    case 'L': {
                        return LEMMA;
                    }
                    case 'N': {
                        return NGRAM;
                    }
                    case 'O': {
                        return ORIGINAL;
                    }
                    case 'P': {
                        return PUNCTUATION;
                    }
                    case 'S': {
                        return SENTENCE;
                    }
                    case 'W': {
                        return WHITESPACE;
                    }
                    case 'G': {
                        return GENERIC;
                    }
                    case 'H': {
                        return HEADER;
                    }
                }
            }
            return BOTH;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        STOPWORD,
        ALL_UPPER,
        HAS_WILDCARD,
        PURE_SPECIAL;

    }
}

