/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;

public class SiteFieldTokenStream
extends TokenStream {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final char PERIOD = '.';
    private static final char COLON = ':';
    private final String site;
    private boolean hasPort;
    private int start;
    private int nextStart;
    private int end;

    public SiteFieldTokenStream(String site) {
        this.site = site;
        this.end = this.site.lastIndexOf(58);
        this.hasPort = this.end != -1;
        this.end = this.hasPort ? this.end : this.site.length();
        this.nextStart = this.site.lastIndexOf(46, this.end);
    }

    public Token next() throws IOException {
        if (this.nextStart != -1) {
            this.start = this.nextStart;
            this.nextStart = this.site.lastIndexOf(46, this.start - 1);
            String termText = this.site.substring(this.start + 1, this.end);
            return new Token(termText, 0, termText.length());
        }
        if (this.end != -1) {
            if (this.hasPort) {
                this.hasPort = false;
                String termText = this.site.substring(0, this.end);
                return new Token(termText, 0, termText.length());
            }
            this.end = -1;
            return new Token(this.site, 0, this.site.length());
        }
        return null;
    }
}

