/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer;

import com.ibm.es.nuvo.parser.Segment;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SegmentsInputStream
extends InputStream {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private List<Segment> allSegments = new LinkedList<Segment>();
    private CharSequenceInputStream is = new CharSequenceInputStream();
    private SegmentCharSequence segment = new SegmentCharSequence();

    SegmentsInputStream() {
    }

    void addSegments(List<Segment> segments) {
        for (Segment s : segments) {
            if (s.getName() != null && !s.getName().equals("title") && !s.test(2048)) continue;
            this.allSegments.add(s);
        }
    }

    @Override
    public int read() throws IOException {
        int ret = this.is.read();
        while (ret < 0) {
            if (this.allSegments.size() == 0) {
                return -1;
            }
            this.segment.reset(this.allSegments.remove(0));
            this.is.reset(this.segment);
            ret = this.is.read();
        }
        return ret;
    }

    @Override
    public int read(byte[] buf, int offs, int len) throws IOException {
        int ret;
        int current;
        for (ret = 0; ret < len; ret += current) {
            current = this.is.read(buf, offs + ret, len - ret);
            if (current != 0) continue;
            if (this.allSegments.size() == 0) break;
            this.segment.reset(this.allSegments.remove(0));
            this.is.reset(this.segment);
        }
        return ret;
    }

    @Override
    public void close() throws IOException {
        this.allSegments.clear();
        this.is.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.allSegments.clear();
    }

    private static class CharSequenceInputStream
    extends InputStream {
        private CharSequence chars;
        private int index;
        private int cp;

        CharSequenceInputStream() {
        }

        CharSequenceInputStream(CharSequence chars) {
            this();
            this.reset(chars);
        }

        public void reset(CharSequence characters) {
            this.chars = characters;
            this.index = 0;
        }

        public void close() throws IOException {
            this.index = 0;
            this.chars = null;
        }

        public int read() throws IOException {
            if (this.chars != null && this.index < this.chars.length() * 2) {
                if (this.index % 2 == 0) {
                    this.cp = Character.codePointAt(this.chars, this.index++ / 2);
                    return this.cp >> 8;
                }
                ++this.index;
                return this.cp % 256;
            }
            return -1;
        }

        public int read(byte[] buf, int offs, int len) throws IOException {
            int ret = 0;
            while (this.chars != null && ret < len && this.index < this.chars.length() * 2) {
                if (this.index % 2 == 0) {
                    this.cp = Character.codePointAt(this.chars, this.index++ / 2);
                    buf[offs + ret++] = (byte)(this.cp >> 8);
                    continue;
                }
                ++this.index;
                buf[offs + ret++] = (byte)(this.cp % 256);
            }
            return ret;
        }
    }

    private static class SegmentCharSequence
    implements CharSequence {
        private String name;
        private CharSequence text;
        private int threshold = -1;
        private int length = 0;
        private int flags;
        private static char DELIMITER = (char)58;

        SegmentCharSequence() {
        }

        SegmentCharSequence(Segment segment) {
            this();
            this.reset(segment);
        }

        public void reset(Segment segment) {
            this.name = segment.getName();
            this.text = segment;
            this.threshold = this.name != null ? this.name.length() : 0;
            this.length = this.threshold + this.text.length() + 2;
            this.flags = segment.getFlags();
        }

        public char charAt(int i) {
            if (i <= this.threshold) {
                return i == this.threshold ? (char)this.flags : this.name.charAt(i);
            }
            if (i < this.length) {
                return i == this.length - 1 ? DELIMITER : this.text.charAt(i - this.threshold - 1);
            }
            throw new IndexOutOfBoundsException();
        }

        public int length() {
            return this.length;
        }

        public CharSequence subSequence(int i, int j) {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }
}

