/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer;

import com.ibm.es.nuvo.common.InvalidArgumentException;
import com.ibm.es.nuvo.facet.CategoryAnalyzer;
import com.ibm.es.nuvo.facet.taxi.FacetAnalyzer;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexWriter;
import com.ibm.es.nuvo.indexer.DocumentStatus;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.normalizer.LanguageNormalizer;
import com.ibm.es.nuvo.tokenizer.ListedTokenStream;
import com.ibm.es.nuvo.tokenizer.SingleNumberTokenStream;
import com.ibm.es.nuvo.tokenizer.SingleNumericPayloadTokenStream;
import com.ibm.es.nuvo.tokenizer.SinglePayloadTokenStream;
import com.ibm.es.nuvo.tokenizer.SiteFieldTokenStream;
import com.ibm.es.nuvo.util.Base64;
import com.ibm.es.nuvo.util.StringUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;

public class PostTokenizeAnalyzer
extends Analyzer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private FacetAnalyzer facetAnalyzer = null;
    private CategoryAnalyzer categoryAnalyzer;
    private static final TokenStream nullTokenStream = new TokenStream(){

        public Token next() throws IOException {
            return null;
        }
    };

    public PostTokenizeAnalyzer(TaxonomyIndexWriter taxiWriter) {
        if (taxiWriter != null) {
            this.facetAnalyzer = new FacetAnalyzer(taxiWriter, "\uf748");
            this.categoryAnalyzer = new CategoryAnalyzer();
        }
    }

    public PostTokenizeAnalyzer() {
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream special = PostTokenizeAnalyzer.specialTokenStream(fieldName, reader);
        if (special != null) {
            return special;
        }
        if (this.facetAnalyzer != null && "_facets".equals(fieldName)) {
            return this.facetAnalyzer.tokenStream(fieldName, reader);
        }
        if (this.categoryAnalyzer != null && "_categories".equals(fieldName)) {
            return this.categoryAnalyzer.tokenStream(fieldName, reader);
        }
        return nullTokenStream;
    }

    public static TokenStream specialTokenStream(String fieldName, Reader reader) {
        block32: {
            if ("_code".equals(fieldName)) {
                return DocumentStatus.tokenStream(reader);
            }
            if ("_datedays".equals(fieldName) || "_urldepth".equals(fieldName) || "_links".equals(fieldName)) {
                try {
                    String value = StringUtils.readerToString(reader);
                    int number = Integer.parseInt(value);
                    return new SingleNumberTokenStream(fieldName, number);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            } else {
                if ("language".equals(fieldName)) {
                    try {
                        return new ListedTokenStream(LanguageNormalizer.list(StringUtils.readerToString(reader)));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break block32;
                    }
                }
                if (fieldName.equals("_dochash")) {
                    try {
                        String value = StringUtils.readerToString(reader);
                        try {
                            long val = Long.parseLong(value);
                            return new SingleNumericPayloadTokenStream(fieldName, val);
                        }
                        catch (NoSuchElementException nse) {
                            nse.printStackTrace();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                } else if (fieldName.equals("site")) {
                    try {
                        String value = StringUtils.readerToString(reader);
                        if (value != null) {
                            return new SiteFieldTokenStream(value);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (fieldName.startsWith("_sec_")) {
                    try {
                        StringTokenizer tok = new StringTokenizer(StringUtils.readerToString(reader), "\uf748");
                        ArrayList<String> list = new ArrayList<String>();
                        while (tok.hasMoreTokens()) {
                            list.add(tok.nextToken());
                        }
                        return new ListedTokenStream(list);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (fieldName.equals("_binary_key")) {
                    String value;
                    try {
                        value = StringUtils.readerToString(reader);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        value = null;
                    }
                    if (value != null) {
                        try {
                            char[] base64 = value.toCharArray();
                            byte[] binary = null;
                            binary = Base64.decode(base64, base64.length);
                            return new SinglePayloadTokenStream("value", 0, binary);
                        }
                        catch (InvalidArgumentException e) {
                            Loggers.logger.log(e);
                            return null;
                        }
                    }
                }
            }
        }
        return null;
    }
}

