/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer;

import com.ibm.es.nuvo.parser.Segment;
import com.ibm.es.nuvo.plugin.MetadataPluginArg;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetadataPluginArgImpl
implements MetadataPluginArg {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Map<String, List<Segment>> FieldNameToSegmentListMap = new HashMap<String, List<Segment>>();
    private List<Segment> plaintextSegmentList = new ArrayList<Segment>();
    private StringBuffer plaintextBuffer = null;
    private byte[] binaryBuffer = null;
    private String collectionId = null;
    private InputStream documentInputStream = null;

    protected MetadataPluginArgImpl(List<Segment> segmentList) {
        for (Segment segment : segmentList) {
            String name = segment.getName();
            if (this.isPlaintextFieldName(name)) {
                this.plaintextSegmentList.add(segment);
                continue;
            }
            if (!this.FieldNameToSegmentListMap.containsKey(name)) {
                this.FieldNameToSegmentListMap.put(name, new ArrayList());
            }
            this.FieldNameToSegmentListMap.get(name).add(segment);
        }
    }

    @Override
    public String getCollectionId() {
        return this.collectionId;
    }

    @Override
    public final byte[] getDocumentContent() {
        if (this.binaryBuffer == null && this.documentInputStream != null) {
            try {
                this.binaryBuffer = new byte[this.documentInputStream.available()];
                this.documentInputStream.read(this.binaryBuffer);
                this.documentInputStream.close();
                this.documentInputStream = null;
            }
            catch (IOException e) {
                this.binaryBuffer = null;
                e.printStackTrace();
            }
        }
        if (this.binaryBuffer == null) {
            this.binaryBuffer = new byte[0];
        }
        return this.binaryBuffer;
    }

    @Override
    public final String getDocumentText() {
        if (this.plaintextBuffer == null) {
            this.plaintextBuffer = new StringBuffer();
            for (Segment segment : this.plaintextSegmentList) {
                this.plaintextBuffer.append(segment.getText());
            }
        }
        return this.plaintextBuffer.toString();
    }

    @Override
    public final String[] getFields() {
        Set<String> fieldNameSet = this.FieldNameToSegmentListMap.keySet();
        String[] fieldNames = fieldNameSet.toArray(new String[fieldNameSet.size()]);
        return fieldNames;
    }

    @Override
    public final String[] getValues(String field) {
        if (this.isPlaintextFieldName(field)) {
            return null;
        }
        List<Segment> segmentList = this.FieldNameToSegmentListMap.get(field);
        if (segmentList == null) {
            return null;
        }
        int i = 0;
        String[] fieldValues = new String[segmentList.size()];
        for (Segment segment : segmentList) {
            fieldValues[i++] = segment.getText();
        }
        return fieldValues;
    }

    @Override
    public int getNumValues(String field) {
        if (this.isPlaintextFieldName(field)) {
            return -1;
        }
        List<Segment> segmentList = this.FieldNameToSegmentListMap.get(field);
        if (segmentList == null) {
            return -1;
        }
        return segmentList.size();
    }

    @Override
    public final String getValue(String field, int n) {
        if (this.isPlaintextFieldName(field)) {
            return null;
        }
        String fieldValue = null;
        List<Segment> segmentList = this.FieldNameToSegmentListMap.get(field);
        if (segmentList != null && n < segmentList.size()) {
            fieldValue = segmentList.get(n).getText();
        }
        return fieldValue;
    }

    @Override
    public final String getValue(String field) {
        return this.getValue(field, 0);
    }

    @Override
    public final void removeField(String field) {
        if (this.isPlaintextFieldName(field)) {
            return;
        }
        this.FieldNameToSegmentListMap.remove(field);
    }

    @Override
    public final void setValues(String field, String[] values) {
        if (this.isPlaintextFieldName(field)) {
            return;
        }
        int flags = 0;
        List<Segment> segmentList = this.FieldNameToSegmentListMap.get(field);
        if (segmentList != null) {
            flags = segmentList.get(0).getFlags();
        }
        flags &= 0xFFFBFFFF;
        this.FieldNameToSegmentListMap.remove(field);
        this.FieldNameToSegmentListMap.put(field, new ArrayList());
        segmentList = this.FieldNameToSegmentListMap.get(field);
        for (String value : values) {
            if (value == null) {
                segmentList.add(Segment.newSegment(field, 0));
                continue;
            }
            segmentList.add(Segment.newSegment(field, value, flags | 0x10000));
        }
        if (segmentList.size() > 0) {
            segmentList.get(segmentList.size() - 1).setFlags(flags | 0x10000 | 0x40000);
        }
    }

    @Override
    public final void setValue(String field, int n, String value) {
        List<Segment> segmentList;
        if (this.isPlaintextFieldName(field)) {
            return;
        }
        if (n < 0) {
            return;
        }
        Segment newSegment = null;
        newSegment = value == null ? Segment.newSegment(field, 0) : Segment.newSegment(field, value, 0);
        if (!this.FieldNameToSegmentListMap.containsKey(field)) {
            this.FieldNameToSegmentListMap.put(field, new ArrayList());
        }
        if (n >= (segmentList = this.FieldNameToSegmentListMap.get(field)).size()) {
            if (segmentList.size() > 0) {
                Segment lastSegment = segmentList.get(segmentList.size() - 1);
                int flags = lastSegment.getFlags();
                lastSegment.setFlags(flags &= 0xFFFBFFFF);
            }
            for (int i = segmentList.size(); i < n; ++i) {
                segmentList.add(Segment.newSegment(field, 0));
            }
            newSegment.setFlags(327680);
            segmentList.add(newSegment);
        } else {
            int flags = segmentList.get(n).getFlags();
            if (n != segmentList.size() - 1) {
                flags &= 0xFFFBFFFF;
            }
            newSegment.setFlags(flags);
            segmentList.set(n, newSegment);
        }
    }

    @Override
    public final void setValue(String field, String value) {
        this.setValue(field, 0, value);
    }

    protected void printInfo() {
        System.out.println("MDPI: number of fields=" + this.FieldNameToSegmentListMap.size());
        for (Map.Entry<String, List<Segment>> entry : this.FieldNameToSegmentListMap.entrySet()) {
            String name = entry.getKey();
            List<Segment> segmentList = entry.getValue();
            int numSegments = segmentList.size();
            String value = segmentList.toString();
            System.out.println("MDPI: FieldName=" + name + " numSegment=" + numSegments + " value=" + value);
        }
        System.out.println("MDPI: number of plaintext segments=" + this.plaintextSegmentList.size());
        System.out.println("MDPI: documentText buffer size=" + this.getDocumentText().length());
        System.out.println("MDPI: documentContent buffer size=" + this.getDocumentContent().length);
    }

    protected List<Segment> getAllSegments() {
        ArrayList<Segment> allSegmentList = new ArrayList<Segment>();
        for (Segment segment : this.plaintextSegmentList) {
            allSegmentList.add(segment);
        }
        Set<String> fieldNameSet = this.FieldNameToSegmentListMap.keySet();
        for (String field : fieldNameSet) {
            List<Segment> segmentList = this.FieldNameToSegmentListMap.get(field);
            for (Segment segment : segmentList) {
                allSegmentList.add(segment);
            }
        }
        return allSegmentList;
    }

    protected void setCollectionId(String cid) {
        this.collectionId = cid;
    }

    protected void setDocumentInputStream(InputStream documentInputStream) {
        this.documentInputStream = documentInputStream;
    }

    private boolean isPlaintextFieldName(String field) {
        return field == null || field.equals("") || field.equals("_xmlvals") || field.equals("_plain");
    }
}

