/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer;

import com.ibm.es.nuvo.anchortext.ReferrerAnchorText;
import com.ibm.es.nuvo.anchortext.TargetAnchorText;
import com.ibm.es.nuvo.tokenizer.TokenVector;
import com.ibm.es.nuvo.tokenizer.TokenizedDocument;
import com.ibm.es.nuvo.tokenizer.TokenizerException;
import com.ibm.es.nuvo.util.Vint8;
import com.ibm.es.nuvo.util.stream.DocumentFieldOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexableDocument
extends TokenizedDocument
implements Serializable {
    private static final long serialVersionUID = -9174974780804339600L;
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int TOKENS_FIELD_SIZE = 262144;
    private static final String[] SUMMARIZER_PREFIX = new String[]{"_tokens", "_@"};
    private ReferrerAnchorText rat;
    private int linkCount = 0;

    private IndexableDocument(Document doc) {
        super(doc);
    }

    IndexableDocument(Document doc, Map<String, TokenVector> fieldMap, int linkCount) {
        super(doc, fieldMap);
        this.linkCount = linkCount;
    }

    public void setAnchorText(TargetAnchorText targetAnchorText) {
        TokenVector anchorText = targetAnchorText.getAnchorText();
        if (anchorText != null) {
            this.getFieldMap().put("_anchor", anchorText);
        }
        this.linkCount = targetAnchorText.getReferrerCount();
    }

    void addPreTokenizedFields(float plainTextBoost) {
        for (Map.Entry<String, TokenVector> entry : this.getFieldMap().entrySet()) {
            String fieldName = entry.getKey();
            TokenVector tokens = entry.getValue();
            if (tokens == null || tokens.isEmpty()) continue;
            String indexFieldName = fieldName;
            if (fieldName.equals("_anchor")) {
                indexFieldName = "_plain";
            }
            tokens.setReadMode(1);
            tokens.begin();
            if (indexFieldName.startsWith("_#")) {
                indexFieldName = indexFieldName.substring("_#".length());
            }
            Field f = new Field(indexFieldName, (TokenStream)tokens);
            if (fieldName.equals("_plain")) {
                f.setBoost(plainTextBoost);
            } else {
                int flags;
                TokenVector.Header header = tokens.getHeader();
                int n = flags = header != null ? header.getFlags() : 0;
                if ((flags & 1) != 0) {
                    f.setOmitNorms(true);
                }
            }
            this.doc.add((Fieldable)f);
        }
    }

    public void writeDocument(Document document, float plainTextBoost) throws IOException {
        this.removeFieldsByPrefix(document, SUMMARIZER_PREFIX);
        document.removeFields("_links");
        Field linkCountField = new Field("_links", Integer.toString(this.linkCount), Field.Store.YES, Field.Index.TOKENIZED);
        linkCountField.setBoost((float)this.linkCount);
        document.add((Fieldable)linkCountField);
        this.addPreTokenizedFields(plainTextBoost);
        this.storeTokenVectors(null);
    }

    void storeTokenVectors(Deflater deflater) throws IOException {
        OutputStream out = new DocumentFieldOutputStream(this.doc, "_tokens", 262144);
        Deflater deflaterToClose = null;
        if (deflater == null) {
            deflater = deflaterToClose = new Deflater();
        } else {
            deflater.reset();
        }
        out = new DeflaterOutputStream(out, deflater);
        Map<String, TokenVector> fieldMap = this.getFieldMap();
        Vint8.encode(0, out);
        Vint8.encode(1, out);
        Vint8.encode(fieldMap.size(), out);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        int count = 0;
        for (Map.Entry<String, TokenVector> entry : fieldMap.entrySet()) {
            String fieldName = entry.getKey();
            TokenVector tokens = entry.getValue();
            baos.reset();
            Vint8.encode(count++, baos);
            Field f = new Field("_@" + fieldName, baos.toByteArray(), Field.Store.YES);
            this.doc.add((Fieldable)f);
            tokens.serialize(out);
        }
        out.close();
        if (deflaterToClose != null) {
            deflaterToClose.end();
        }
    }

    public ReferrerAnchorText getReferrerAnchorText() {
        return this.rat;
    }

    void setReferrerAnchorText(ReferrerAnchorText rat) {
        this.rat = rat;
    }

    private void removeFieldsByPrefix(Document document, String[] fieldNamePrefix) {
        HashSet<String> fieldNamesFound = new HashSet<String>();
        block0: for (Object obj : document.getFields()) {
            Field field = (Field)obj;
            if (field == null || field.name() == null) continue;
            for (String prefix : fieldNamePrefix) {
                if (!field.name().startsWith(prefix)) continue;
                fieldNamesFound.add(field.name());
                continue block0;
            }
        }
        Iterator iter = fieldNamesFound.iterator();
        while (iter.hasNext()) {
            document.removeFields((String)iter.next());
        }
    }

    public static final IndexableDocument loadFromDocument(Document doc) throws IOException, TokenizerException {
        if (doc == null) {
            throw new IllegalArgumentException();
        }
        IndexableDocument indexableDocument = new IndexableDocument(doc);
        indexableDocument.loadTokenVectors(true);
        return indexableDocument;
    }
}

