/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.FieldDefinition;
import com.ibm.es.nuvo.configuration.FieldDefinitions;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.normalizer.NormalizedStringBuffer;
import com.ibm.es.nuvo.normalizer.NormalizedStringBufferType1;
import com.ibm.es.nuvo.normalizer.NormalizedStringBufferType2;
import com.ibm.es.nuvo.parser.ParserException;
import com.ibm.es.nuvo.parser.ParserHandler;
import com.ibm.es.nuvo.parser.Segment;
import com.ibm.es.nuvo.parser.XMLTagInfo;
import com.ibm.es.nuvo.parser.XMLTextBuffers;
import com.ibm.es.nuvo.plugin.MetadataPlugin;
import com.ibm.es.nuvo.plugin.MetadataPluginClassLoader;
import com.ibm.es.nuvo.tokenizer.Anchor;
import com.ibm.es.nuvo.tokenizer.MetadataPluginArgImpl;
import com.ibm.es.nuvo.tokenizer.TokenizerProcessInput;
import com.ibm.es.nuvo.util.DateParser;
import com.ibm.es.nuvo.util.decimal.Decimal;
import com.ibm.supa.config.AnalysisScopeConfig;
import com.ibm.supa.config.ConfigurationLoader;
import com.ibm.supa.metadata.plugins.DelegateMetadataPlugin;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FieldAggregator
implements ParserHandler {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int INITIAL_BUFFER_SIZE = 4096;
    private List<Segment> fields;
    private List<Anchor> anchors;
    private NormalizedStringBuffer documentText;
    private NormalizedStringBuffer normalizeBuffer;
    private Segment previousSegment;
    private int currentStart;
    private int currentEnd;
    private String currentTargetURL;
    private TokenizerProcessInput processInput;
    private Map<String, FieldDefinition> fdMap;
    private List<Segment> tokenizedFields;
    private List<Segment> storedFields;
    private List<Segment> untokenizedFields;
    private List<Segment> untokenizedStoredFields;
    private List<Segment> parametricFields;
    private List<Segment> facetFields;
    private StringBuilder textBuffer;
    private StringBuilder tempBuffer;
    private Map<String, String> defaultValues;
    private Set<String> needDefault;
    private static FieldDefinition defaultDef = new FieldDefinition(null);
    private MetadataPlugin metadataPlugin;
    private String collectionId;
    private InputStream documentInputStream;
    private String documentURI;
    private Metadata metadata;

    FieldAggregator(CollectionConfiguration config) {
        block9: {
            this.fields = new ArrayList<Segment>();
            this.anchors = new ArrayList<Anchor>();
            this.documentText = new NormalizedStringBufferType1(4096, false);
            this.normalizeBuffer = new NormalizedStringBufferType2(32);
            this.textBuffer = new StringBuilder(4096);
            this.tempBuffer = new StringBuilder(128);
            this.processInput = null;
            if (config.getFieldDefinitions() != null) {
                this.fdMap = config.getFieldDefinitions().getFieldDefinitions(FieldDefinitions.ALL);
            } else {
                try {
                    this.fdMap = FieldDefinitions.createDefault().getFieldDefinitions(FieldDefinitions.ALL);
                }
                catch (ExtendedException e) {
                    if (!Loggers.logger.isLoggable(Level.SEVERE)) break block9;
                    Loggers.logger.log(Level.SEVERE, e);
                }
            }
        }
        for (FieldDefinition def : this.fdMap.values()) {
            if (def.getDefaultValue() == null) continue;
            if (this.defaultValues == null) {
                this.defaultValues = new HashMap<String, String>();
            }
            this.defaultValues.put(def.getName(), def.getDefaultValue());
        }
        this.storedFields = new ArrayList<Segment>();
        this.tokenizedFields = new ArrayList<Segment>();
        this.untokenizedFields = new ArrayList<Segment>();
        this.untokenizedStoredFields = new ArrayList<Segment>();
        this.parametricFields = new ArrayList<Segment>();
        this.facetFields = new ArrayList<Segment>();
        if (this.defaultValues != null) {
            this.needDefault = new HashSet<String>();
        }
        this.collectionId = config.getId();
        this.documentInputStream = null;
        MetadataPluginClassLoader mpcl = GlobalSystem.getSingleInstance().getMetadataPluginClassLoader();
        this.metadataPlugin = mpcl.getMetadataPlugin();
        try {
            AnalysisScopeConfig asConfig = ConfigurationLoader.getAnalysisScopeConfig(config.getId());
            DelegateMetadataPlugin plugin = asConfig.getMetadataPlugin();
            plugin.setMetadataPlugin(this.metadataPlugin);
            this.metadataPlugin = plugin;
        }
        catch (RuntimeException e) {
            Loggers.logger.severe("Problem initializing tokenizer: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw e;
        }
    }

    List<Anchor> getAnchors() {
        return this.anchors;
    }

    @Override
    public void startDocument(String uri, Metadata metadata) throws ParserException {
        this.textBuffer = new StringBuilder();
        this.previousSegment = null;
        this.currentStart = 0;
        this.currentEnd = 0;
        this.currentTargetURL = null;
        this.fields.clear();
        this.anchors.clear();
        this.processInput = new TokenizerProcessInput();
        if (this.needDefault != null) {
            this.needDefault.addAll(this.defaultValues.keySet());
        }
        this.documentURI = uri;
        this.metadata = metadata;
    }

    @Override
    public void endDocument() {
        if (this.needDefault != null) {
            if (this.previousSegment != null) {
                this.needDefault.remove(this.previousSegment.getName());
            }
            Set<String> tmp = this.needDefault;
            this.needDefault = null;
            for (String name : tmp) {
                this.addSegment(Segment.newSegment(name, this.defaultValues.get(name), 262144));
            }
            this.needDefault = tmp;
        }
        this.flush();
        this.callMetadataPlugin();
        this.createFields();
        this.metadata = null;
    }

    private void callMetadataPlugin() {
        if (this.metadataPlugin != null) {
            DelegateMetadataPlugin delegateMetadataPlugin = null;
            if (this.metadataPlugin instanceof DelegateMetadataPlugin) {
                String docText = null;
                for (Segment segment : this.fields) {
                    if (segment.getName() != null) continue;
                    docText = segment.getText();
                    break;
                }
                delegateMetadataPlugin = (DelegateMetadataPlugin)this.metadataPlugin;
                delegateMetadataPlugin.setDocumentText(docText);
                delegateMetadataPlugin.setMetadata(this.metadata);
            }
            MetadataPluginArgImpl mdpArg = new MetadataPluginArgImpl(this.fields);
            mdpArg.setCollectionId(this.collectionId);
            mdpArg.setDocumentInputStream(this.documentInputStream);
            try {
                boolean PluginResult = this.metadataPlugin.execute(mdpArg);
                if (PluginResult) {
                    this.fields = mdpArg.getAllSegments();
                }
            }
            catch (Throwable e) {
                Loggers.logger.log(Level.WARNING, new Message("P7010W.MD_PLUGIN_EXECUTE_ERROR", this.metadataPlugin.getClass().getName(), this.documentURI, e.getMessage()));
            }
            if (delegateMetadataPlugin != null) {
                delegateMetadataPlugin.setDocumentText(null);
                delegateMetadataPlugin.setMetadata(null);
            }
        }
    }

    @Override
    public void addSegment(Segment segment) {
        if (!segment.compatible(this.previousSegment) || this.previousSegment != null && this.previousSegment.test(262144)) {
            this.flush();
        }
        if (segment.test(524288)) {
            this.currentTargetURL = segment.getText();
        } else {
            int len = segment.length();
            if (len > 0) {
                this.textBuffer.append(segment);
            }
            if (segment.test(65536) || segment.test(262144)) {
                this.textBuffer.append("\n\n");
            }
        }
        this.previousSegment = segment;
    }

    @Override
    public void addXMLTagInfo(XMLTagInfo xti) throws ParserException {
        this.processInput.addXMLTagInfo(xti);
        this.createSegmentsFromXMLBuffers();
    }

    List<Segment> getStoredFields() {
        return this.storedFields;
    }

    List<Segment> getTokenizedFields() {
        return this.tokenizedFields;
    }

    List<Segment> getUntokenizedFields() {
        return this.untokenizedFields;
    }

    List<Segment> getUntokenizedStoredFields() {
        return this.untokenizedStoredFields;
    }

    List<Segment> getParametricFields() {
        return this.parametricFields;
    }

    List<Segment> getFacetFields() {
        return this.facetFields;
    }

    TokenizerProcessInput getTokenizerProcessInput() {
        this.processInput.setText(this.documentText);
        return this.processInput;
    }

    private void flush() {
        this.currentEnd = this.textBuffer.length();
        if (this.previousSegment != null && (this.previousSegment.test(65536) || this.previousSegment.test(262144))) {
            this.currentEnd -= "\n\n".length();
        }
        if (this.currentEnd > this.currentStart) {
            boolean anchortext;
            Segment newSegment = Segment.newSegment(this.previousSegment.getName(), this.textBuffer, this.currentStart, this.currentEnd - this.currentStart, this.previousSegment.getNumericValue(), this.previousSegment.getFlags());
            boolean bl = anchortext = this.currentTargetURL != null && this.previousSegment.test(1024);
            if (anchortext) {
                newSegment.setAnchor(this.currentTargetURL);
            }
            this.fields.add(newSegment);
            this.currentStart = this.textBuffer.length();
            if (this.needDefault != null && this.previousSegment.getName() != null) {
                this.needDefault.remove(this.previousSegment.getName());
            }
        }
        this.currentTargetURL = null;
    }

    private void createSegmentsFromXMLBuffers() throws ParserException {
        XMLTextBuffers xtb = this.processInput.getXMLTextBuffers();
        if (xtb != null) {
            CharSequence tb = xtb.getXMLBuffer(0);
            if (tb != null && tb.length() > 0) {
                this.addSegment(Segment.newSegment(null, tb, 0, tb.length(), 65536));
            }
            int valueOffset = this.textBuffer.length();
            this.processInput.setAttributeValueSet(false);
            tb = xtb.getXMLBuffer(1);
            if (tb != null && tb.length() > 0) {
                this.processInput.setStartOfAttributeValues(valueOffset);
                this.processInput.setAttributeValueSet(true);
                this.addSegment(Segment.newSegment("_xmlvals", tb, 0, tb.length(), 65536));
            }
        }
    }

    private void createFields() {
        this.tokenizedFields.clear();
        this.untokenizedFields.clear();
        this.storedFields.clear();
        this.untokenizedStoredFields.clear();
        this.parametricFields.clear();
        this.facetFields.clear();
        this.documentText.setLength(0);
        for (Segment segment : this.fields) {
            FieldDefinition def = this.getDefinition(segment);
            if (def != null) {
                boolean anchortext;
                int start = this.documentText.length();
                int end = this.documentText.length();
                boolean fullTextSearch = def.isFullTextSearchable();
                boolean tokenizedFieldSearch = def.isFieldSearchable() && def.getFieldSearchAttr().isTokenized();
                boolean noLemmatizedFieldSearch = tokenizedFieldSearch && !def.getFieldSearchAttr().isLemmatized();
                boolean untokenizedFieldSearch = def.isFieldSearchable() && !def.getFieldSearchAttr().isTokenized();
                boolean store = def.isReturnable();
                boolean caseSensitive = untokenizedFieldSearch && def.getFieldSearchAttr().isCaseSensitive();
                boolean facets = def.isCategory();
                if (fullTextSearch || tokenizedFieldSearch) {
                    start = this.documentText.length();
                    this.documentText.append(segment);
                    end = this.documentText.length();
                    if (segment.getName() == null) {
                        int startOfAttributeValues = this.processInput.getStartOfAttributeValues();
                        if (!this.processInput.isAttributeValueSet() || end <= startOfAttributeValues) {
                            this.processInput.setEndOfPlaintextPosition(end);
                        }
                    }
                    int flags = segment.getFlags();
                    if (fullTextSearch) {
                        flags |= 1;
                    }
                    if (tokenizedFieldSearch) {
                        flags |= 2;
                    }
                    if (noLemmatizedFieldSearch) {
                        flags |= 4;
                    }
                    this.tokenizedFields.add(Segment.newSegment(segment.getName(), this.documentText, start, this.documentText.length() - start, flags));
                    store = false;
                }
                if (store) {
                    if (untokenizedFieldSearch) {
                        if (caseSensitive) {
                            this.untokenizedStoredFields.add(segment);
                        } else {
                            this.tempBuffer.setLength(0);
                            segment.appendTo(this.tempBuffer);
                            this.normalizeBuffer.setLength(0);
                            segment.appendTo(this.normalizeBuffer);
                            String original = this.tempBuffer.toString();
                            String normalized = this.normalizeBuffer.toString();
                            if (!original.equals(normalized)) {
                                this.untokenizedFields.add(Segment.newSegment(segment.getName(), normalized, segment.getFlags()));
                                this.storedFields.add(segment);
                            } else {
                                this.untokenizedStoredFields.add(segment);
                            }
                        }
                    } else {
                        this.storedFields.add(segment);
                    }
                } else if (untokenizedFieldSearch) {
                    if (caseSensitive) {
                        this.untokenizedFields.add(segment);
                    } else {
                        this.normalizeBuffer.setLength(0);
                        segment.appendTo(this.normalizeBuffer);
                        String normalized = this.normalizeBuffer.toString();
                        this.untokenizedFields.add(Segment.newSegment(segment.getName(), normalized, segment.getFlags()));
                    }
                }
                if (facets) {
                    this.facetFields.add(segment);
                }
                if (def.isParametricSearchable()) {
                    this.tempBuffer.setLength(0);
                    segment.appendTo(this.tempBuffer);
                    String str = this.tempBuffer.toString();
                    FieldDefinition.ParametricSearchAttributes attr = def.getParametricSearchAttr();
                    try {
                        Decimal value = segment.getNumericValue();
                        if (value == null) {
                            switch (attr.getType()) {
                                case Date: {
                                    try {
                                        value = new Decimal(DateParser.parse(str));
                                    }
                                    catch (Throwable e) {
                                        value = new Decimal(new Date(Long.parseLong(str)));
                                    }
                                    break;
                                }
                                default: {
                                    try {
                                        value = new Decimal(Long.parseLong(str));
                                        break;
                                    }
                                    catch (Throwable e) {
                                        try {
                                            value = new Decimal(DateParser.parse(str));
                                            break;
                                        }
                                        catch (Throwable e1) {
                                            value = new Decimal(Double.parseDouble(str), attr.getPrecision());
                                        }
                                    }
                                }
                            }
                        }
                        if (value != null) {
                            this.parametricFields.add(Segment.newSegment(segment.getName(), str, new Decimal(value.doubleValue(), attr.getPrecision()), 0));
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                boolean bl = anchortext = segment.test(1024) && segment.getAnchor() != null;
                if (anchortext) {
                    this.anchors.add(new Anchor(segment.getAnchor(), start, end));
                }
            }
            if (!segment.test(65536) && !segment.test(262144)) continue;
            this.documentText.append("\n\n");
        }
    }

    private FieldDefinition getDefinition(Segment segment) {
        return segment.getName() != null ? this.fdMap.get(segment.getName()) : defaultDef;
    }

    public List<Segment> getFields() {
        return this.fields;
    }

    public StringBuilder getTextBuffer() {
        return this.textBuffer;
    }

    public NormalizedStringBuffer getDocumentText() {
        return this.documentText;
    }

    public final void setDocumentInputStream(InputStream documentInputStream) {
        this.documentInputStream = documentInputStream;
    }

    static {
        defaultDef.setFullTextSearchable(true);
    }
}

