/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer;

import com.ibm.es.nuvo.markup.util.MarkupPayload;
import com.ibm.es.nuvo.tokenizer.TToken;

public abstract class BaseTagToken
extends TToken {
    public BaseTagToken() {
        super(TToken.Type.GENERIC);
    }

    public char charAt(int i) {
        return this.getTagAttrName().charAt(i);
    }

    public int length() {
        return this.getTagAttrName().length();
    }

    public CharSequence subSequence(int start, int end) {
        return this.getTagAttrName().subSequence(start, end);
    }

    public String toString() {
        return this.getTagAttrName();
    }

    public abstract String getTagAttrName();

    public abstract int getTagAttrSerial();

    public abstract int getTagAttrTokenBegin();

    public abstract int getTagAttrTokenEnd();

    public abstract int getTagAttrTokenZero();

    public int getPositionIncrement() {
        return this.getTagAttrTokenBegin() - this.getTagAttrTokenZero();
    }

    public abstract boolean isAttr();

    public CharSequence getAttributeValue() {
        return null;
    }

    public Object getNumericValue() {
        String v;
        CharSequence cs = this.getAttributeValue();
        if (cs != null && (v = ((Object)cs).toString()) != null && (v = v.trim()) != null && v.length() > 0) {
            try {
                return Long.parseLong(v);
            }
            catch (Exception e1) {
                try {
                    return Double.parseDouble(v);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            this.payload = MarkupPayload.newPayload(this.getTagAttrSerial(), this.getTagAttrTokenEnd() - this.getTagAttrTokenBegin());
        }
        return this.payload;
    }

    public abstract void setTagAttrTokenZero(int var1);
}

