/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer;

import com.ibm.es.nuvo.tokenizer.TokenVector;
import org.apache.lucene.analysis.Token;

public class Anchor {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public String target;
    public int begin;
    public int end;
    TokenVector tokens;

    public Anchor(String targetUrl, int begin, int end) {
        this.target = targetUrl;
        this.begin = begin;
        this.end = end;
        this.tokens = null;
    }

    public void setTokenVector(TokenVector vector) {
        this.tokens = vector;
    }

    public TokenVector getTokenVector() {
        return this.tokens;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String newline = System.getProperty("line.separator");
        buf.append("Anchor -> ");
        if (this.target == null) {
            buf.append("<no target>");
        } else {
            buf.append(this.target);
        }
        buf.append(":");
        buf.append(newline);
        if (this.tokens == null) {
            buf.append(" <empty anchor>");
            buf.append(newline);
        } else {
            Token token;
            this.tokens.setReadMode(4);
            this.tokens.begin();
            int tNum = 0;
            while ((token = this.tokens.next()) != null) {
                buf.append("  #").append(++tNum).append(" (+").append(token.getPositionIncrement()).append(' ').append(token.startOffset()).append('-').append(token.endOffset()).append(" '").append(token.termText()).append("') [").append(token.type()).append(']').append(newline);
            }
            this.tokens.close();
        }
        return buf.toString();
    }

    public static void main(String[] args) {
    }
}

