/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer;

import com.ibm.es.nuvo.normalizer.NormalizedStringBuffer;
import com.ibm.es.nuvo.normalizer.NormalizedStringBufferType1;
import com.ibm.es.nuvo.normalizer.NormalizedStringBufferType2;
import com.ibm.es.nuvo.tokenizer.NormalizedResultHandler;
import com.ibm.es.nuvo.tokenizer.ResultHandler;
import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.es.nuvo.tokenizer.Tokenizer;
import com.ibm.es.nuvo.tokenizer.TokenizerException;
import com.ibm.es.nuvo.tokenizer.TokenizerProcessInput;
import com.ibm.es.nuvo.tokenizer.XMLToken;
import java.util.Iterator;

public abstract class AbstractTokenizer
implements Tokenizer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private NormalizedStringBuffer type1Normalizer = new NormalizedStringBufferType1();
    private NormalizedStringBuffer type2Normalizer = new NormalizedStringBufferType2();

    public void process(ResultHandler handler, TokenizerProcessInput tpi) throws TokenizerException {
        System.err.println("AbstractTokenizer.process(h,t): should never happen.");
    }

    public void process(NormalizedResultHandler handler, CharSequence textToAnalyze, String knownLanguage, String defaultLanguage) throws TokenizerException {
        this.type1Normalizer.setLength(0);
        this.type1Normalizer.append(textToAnalyze);
        this.process(new Type2NormalizedResultHandler(handler), new TokenizerProcessInput(this.type1Normalizer, knownLanguage, defaultLanguage));
    }

    private final class Type2NormalizedResultHandler
    implements ResultHandler {
        private final NormalizedResultHandler handler;

        private Type2NormalizedResultHandler(NormalizedResultHandler h) {
            this.handler = h;
        }

        public void addToken(TToken token, int begin, int end) {
            if (token != null) {
                AbstractTokenizer.this.type2Normalizer.setLength(0);
                AbstractTokenizer.this.type2Normalizer.append(token);
                TToken normToken = TToken.newToken(AbstractTokenizer.this.type2Normalizer, token.getType());
                Iterator props = token.getProperties().iterator();
                while (props.hasNext()) {
                    normToken.addProperty((TToken.Property)((Object)props.next()));
                }
                this.handler.addToken(normToken);
            } else {
                this.handler.addToken(null);
            }
        }

        public void addField(String name, String value) {
        }

        public void addXMLToken(XMLToken xmlToken) {
            System.err.println("Type2 handler got XML token: should never happen.");
        }

        public void close() {
        }

        public void reset() {
        }
    }
}

