/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.synonym.request;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.ConfigurationRequest;
import com.ibm.es.nuvo.synonym.index.SynonymIndexWriter;
import java.io.InputStream;

public class ImportSynonymRequest
implements ConfigurationRequest {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    InputStream is = null;

    public ImportSynonymRequest(InputStream is) {
        this.is = is;
    }

    public ConfigurationRequest process(String collectionId) throws Exception {
        SynonymIndexWriter writer = null;
        try {
            writer = SynonymIndexWriter.open(collectionId);
            writer.importFromXML(this.is);
        }
        catch (Exception e) {
            Message msg = new Message("A0159E.UNABLE_TO_IMPORT_SYNONYMS");
            msg.addArgument(collectionId);
            throw new ExtendedException(msg, (Throwable)e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return null;
    }
}

