/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.synonym.index;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.normalizer.NormalizedStringBuffer;
import com.ibm.es.nuvo.normalizer.NormalizedStringBufferType2;
import com.ibm.es.nuvo.synonym.factory.SynonymGroup;
import com.ibm.es.nuvo.synonym.factory.SynonymGroups;
import com.ibm.es.nuvo.synonym.factory.SynonymGroupsSAXParseException;
import com.ibm.es.nuvo.synonym.index.SynonymIndexCreationException;
import com.ibm.es.nuvo.synonym.index.SynonymIndexReadException;
import com.ibm.es.nuvo.synonym.index.SynonymIndexReader;
import com.ibm.es.nuvo.tokenizer.TokenizerUtilities;
import com.ibm.es.nuvo.util.Base64;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;

public class SynonymIndexWriter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private File indexPath = null;
    private IndexWriter indexWriter = null;

    private SynonymIndexWriter(File synonymIndexPath) throws SynonymIndexReadException {
        this.init(synonymIndexPath);
    }

    private SynonymIndexWriter(String cid) throws ConfigurationManagerException, SynonymIndexReadException {
        if (null == cid) {
            cid = "";
        }
        CollectionConfiguration collConfig = ConfigurationManager.getConfigurationManager().getCollection(cid);
        String synIndexPath = collConfig.getIndexPath(IndexDescriptor.IndexType.Synonym);
        this.init(new File(synIndexPath));
    }

    private void init(File synonymIndexPath) throws SynonymIndexReadException {
        this.indexPath = synonymIndexPath;
        boolean create = false;
        if (!IndexReader.indexExists((File)this.indexPath)) {
            create = true;
        }
        try {
            this.indexWriter = new IndexWriter(this.indexPath, (Analyzer)new StandardAnalyzer(), create);
        }
        catch (IOException e) {
            throw new SynonymIndexReadException(e);
        }
    }

    public void add(SynonymGroup newGroup) throws SynonymIndexCreationException, SynonymIndexReadException {
        if (null == this.get(newGroup.getKey())) {
            this.addSynonymGroupToIndex(newGroup);
        }
        if (newGroup.size() <= 1) {
            throw new SynonymIndexCreationException(new Message("A1483E.synonyms.more.than.one"));
        }
    }

    public SynonymGroup replace(byte[] synonymGroupKey, SynonymGroup newGroup) throws SynonymIndexReadException, SynonymIndexCreationException {
        SynonymGroup replacedGroup = this.removeSynonymGroupFromIndex(synonymGroupKey);
        this.addSynonymGroupToIndex(newGroup);
        return replacedGroup;
    }

    public SynonymGroup replace(String base64EncodedKey, SynonymGroup newGroup) throws SynonymIndexReadException, SynonymIndexCreationException {
        SynonymGroup replacedGroup = this.removeSynonymGroupFromIndex(base64EncodedKey);
        this.addSynonymGroupToIndex(newGroup);
        return replacedGroup;
    }

    public void removeAll() throws SynonymIndexReadException {
        try {
            this.indexWriter = new IndexWriter(this.indexPath, (Analyzer)new StandardAnalyzer(), true);
        }
        catch (IOException e) {
            throw new SynonymIndexReadException(e);
        }
    }

    public SynonymGroup remove(byte[] synonymGroupKey) throws SynonymIndexReadException {
        SynonymGroup removedGroup = this.removeSynonymGroupFromIndex(synonymGroupKey);
        return removedGroup;
    }

    public SynonymGroup remove(String base64EncodedKey) throws SynonymIndexReadException {
        SynonymGroup removedGroup = this.removeSynonymGroupFromIndex(base64EncodedKey);
        return removedGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynonymGroup get(byte[] synonymGroupKey) throws SynonymIndexReadException {
        SynonymGroup retGroup = null;
        SynonymIndexReader reader = null;
        try {
            reader = SynonymIndexReader.open(this.indexPath);
            retGroup = reader.get(synonymGroupKey);
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
        return retGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynonymGroup get(String base64EncodedKey) throws SynonymIndexReadException {
        SynonymGroup retGroup = null;
        SynonymIndexReader reader = null;
        try {
            reader = SynonymIndexReader.open(this.indexPath);
            retGroup = reader.get(base64EncodedKey);
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
        return retGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynonymGroups getSynonymGroups() throws SynonymIndexReadException {
        SynonymGroups retGroups = null;
        SynonymIndexReader reader = null;
        try {
            reader = SynonymIndexReader.open(this.indexPath);
            retGroups = reader.getSynonymGroups();
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
        return retGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SynonymIndexReadException {
        try {
            File file = this.indexPath;
            synchronized (file) {
                this.indexWriter.optimize();
                this.indexWriter.close();
            }
        }
        catch (IOException e) {
            throw new SynonymIndexReadException(e);
        }
    }

    public void importFromXML(InputStream inputStream) throws SynonymGroupsSAXParseException, SynonymIndexCreationException, SynonymIndexReadException {
        SynonymGroups groups = SynonymGroups.createFrom(inputStream);
        Iterator iterator = groups.iterator();
        while (iterator.hasNext()) {
            this.add((SynonymGroup)iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSynonymGroupToIndex(SynonymGroup synonymGroup) throws SynonymIndexCreationException {
        Document doc = new Document();
        String[] synonyms = synonymGroup.toArray();
        NormalizedStringBuffer type2Normalized = SynonymIndexWriter.createNormalizerForIndexSearch();
        try {
            String start;
            HashMap<String, Integer> startsHashMap = new HashMap<String, Integer>();
            for (int i = 0; i < synonyms.length; ++i) {
                Integer startMaxLen;
                String curSyn = synonyms[i];
                if (null == curSyn) continue;
                String[] tokens = TokenizerUtilities.whiteSpaceTokenize(type2Normalized, curSyn);
                String normalized2Synonym = type2Normalized.toString();
                ArrayList<String> filteredTokens = new ArrayList<String>();
                for (int j = 0; j < tokens.length; ++j) {
                    if (tokens[j].length() <= 0) continue;
                    filteredTokens.add(tokens[j]);
                }
                if (tokens.length > filteredTokens.size()) {
                    tokens = new String[filteredTokens.size()];
                    filteredTokens.toArray(tokens);
                }
                if (null == (startMaxLen = (Integer)startsHashMap.get(start = tokens[0])) || startMaxLen < tokens.length) {
                    startsHashMap.put(start, tokens.length);
                }
                Field synField = new Field("synIndex", normalized2Synonym, Field.Store.NO, Field.Index.UN_TOKENIZED);
                doc.add((Fieldable)synField);
                Field synField2 = new Field("synStore", curSyn, Field.Store.YES, Field.Index.NO);
                doc.add((Fieldable)synField2);
            }
            Field keyField = new Field("key", synonymGroup.getBase64Key(), Field.Store.YES, Field.Index.UN_TOKENIZED);
            doc.add((Fieldable)keyField);
            for (Map.Entry curEntry : startsHashMap.entrySet()) {
                int maxValue = (Integer)curEntry.getValue();
                start = (String)curEntry.getKey();
                Field startField = new Field("starts", start, Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.YES);
                for (int i = 0; i < maxValue; ++i) {
                    doc.add((Fieldable)startField);
                }
            }
            File file = this.indexPath;
            synchronized (file) {
                this.indexWriter.addDocument(doc);
            }
        }
        catch (IOException ioe) {
            throw new SynonymIndexCreationException(synonymGroup.toString(), (Throwable)ioe);
        }
    }

    private SynonymGroup removeSynonymGroupFromIndex(byte[] key) throws SynonymIndexReadException {
        if (null == key) {
            return null;
        }
        return this.removeSynonymGroupFromIndex(Base64.encode(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SynonymGroup removeSynonymGroupFromIndex(String base64EncodedKey) throws SynonymIndexReadException {
        SynonymGroup retGroup;
        block17: {
            if (null == base64EncodedKey) {
                return null;
            }
            retGroup = null;
            IndexReader reader = null;
            try {
                Document doc;
                String[] values;
                reader = IndexReader.open((File)this.indexPath);
                Term term = new Term("key", base64EncodedKey);
                TermDocs termDocs = reader.termDocs(term);
                if (!termDocs.next() || null == (values = (doc = reader.document(termDocs.doc())).getValues("synStore"))) break block17;
                retGroup = new SynonymGroup();
                for (int i = 0; i < values.length; ++i) {
                    retGroup.add(values[i]);
                }
                File file = this.indexPath;
                synchronized (file) {
                    this.indexWriter.close();
                    reader.deleteDocument(termDocs.doc());
                    try {
                        reader.close();
                        reader = null;
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    this.indexWriter = new IndexWriter(this.indexPath, (Analyzer)new StandardAnalyzer(), false);
                }
            }
            catch (IOException ioe) {
                throw new SynonymIndexReadException(ioe);
            }
            finally {
                if (null != reader) {
                    try {
                        reader.close();
                        reader = null;
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return retGroup;
    }

    public static SynonymIndexWriter open(String cid) throws ConfigurationManagerException, SynonymIndexReadException {
        return new SynonymIndexWriter(cid);
    }

    public static SynonymIndexWriter open(File path) throws SynonymIndexReadException {
        return new SynonymIndexWriter(path);
    }

    public static String normalize(String query) {
        NormalizedStringBuffer type2Normalized = SynonymIndexWriter.createNormalizerForIndexSearch();
        String[] splitted = query.split("\\s");
        for (int i = 0; i < splitted.length; ++i) {
            if (splitted[i].length() <= 0) continue;
            type2Normalized.append(splitted[i]);
            type2Normalized.append(' ');
        }
        return type2Normalized.substring(0, type2Normalized.length() - 1);
    }

    public static NormalizedStringBuffer createNormalizerForIndexSearch() {
        return new NormalizedStringBufferType2();
    }
}

