/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.synonym.index;

import com.ibm.es.nuvo.normalizer.NormalizedStringBuffer;
import com.ibm.es.nuvo.synonym.index.SynonymIndexWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.search.IndexSearcher;

public class SynonymIndexSearcher {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private IndexReader synonymIndexReader = null;

    public SynonymIndexSearcher(IndexSearcher indexSearcher) {
        this.updateIndexSearcher(indexSearcher);
    }

    public String[] getSynonyms(String query) {
        return this.getSynonyms(query, true);
    }

    public String[] getSynonyms(String queryType2Normalized, boolean excludeQueryFromOutput) {
        String[] synonyms = null;
        try {
            Term term = new Term("synIndex", queryType2Normalized);
            if (this.synonymIndexReader.docFreq(term) > 0) {
                int i;
                ArrayList<String> retSynonyms = new ArrayList<String>();
                TermDocs termDocs = this.synonymIndexReader.termDocs(term);
                while (termDocs.next()) {
                    Document doc = this.synonymIndexReader.document(termDocs.doc());
                    String[] values = doc.getValues("synStore");
                    if (null == values) continue;
                    for (i = 0; i < values.length; ++i) {
                        retSynonyms.add(values[i]);
                    }
                }
                if (excludeQueryFromOutput) {
                    NormalizedStringBuffer normalizer = SynonymIndexWriter.createNormalizerForIndexSearch();
                    int size = retSynonyms.size();
                    for (i = 0; i < size; ++i) {
                        normalizer.setLength(0);
                        normalizer.append((CharSequence)retSynonyms.get(i));
                        String normalized = normalizer.toString();
                        if (!normalized.equals(queryType2Normalized)) continue;
                        retSynonyms.remove(i);
                        --i;
                        --size;
                    }
                }
                if (retSynonyms.size() > 0) {
                    synonyms = new String[retSynonyms.size()];
                    retSynonyms.toArray(synonyms);
                }
            }
        }
        catch (IOException ioe) {
            synonyms = null;
        }
        if (null == synonyms) {
            synonyms = new String[]{};
        }
        return synonyms;
    }

    public int[] identifyCandidates(String[] termsType2Normalized) {
        if (null == termsType2Normalized) {
            return null;
        }
        int[] candidateMatches = new int[termsType2Normalized.length];
        if (termsType2Normalized.length > 0) {
            for (int i = 0; i < termsType2Normalized.length; ++i) {
                candidateMatches[i] = this.identifyCandidate(termsType2Normalized[i]);
            }
        }
        return candidateMatches;
    }

    public int identifyCandidate(String termType2Normalized) {
        if (null == termType2Normalized) {
            return 0;
        }
        Term term = new Term("starts", termType2Normalized);
        int retValue = 0;
        try {
            TermDocs termDocs;
            if (this.synonymIndexReader.docFreq(term) > 0 && null != (termDocs = this.synonymIndexReader.termDocs(term))) {
                while (termDocs.next()) {
                    int[] termFrequencies;
                    int termIndex;
                    int docNumber = termDocs.doc();
                    TermFreqVector tfVector = this.synonymIndexReader.getTermFreqVector(docNumber, "starts");
                    if (null == tfVector || (termIndex = tfVector.indexOf(termType2Normalized)) < 0 || (termFrequencies = tfVector.getTermFrequencies())[termIndex] <= retValue) continue;
                    retValue = termFrequencies[termIndex];
                }
            }
        }
        catch (IOException ioe) {
            retValue = 0;
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndexSearcher(IndexSearcher indexSearcher) {
        if (null == indexSearcher) {
            throw new NullPointerException("indexSearcher is null");
        }
        SynonymIndexSearcher synonymIndexSearcher = this;
        synchronized (synonymIndexSearcher) {
            this.synonymIndexReader = indexSearcher.getIndexReader();
        }
    }

    public static void main(String[] args) {
        try {
            String candidate;
            IndexSearcher searcher = new IndexSearcher(args[0]);
            SynonymIndexSearcher synSearcher = new SynonymIndexSearcher(searcher);
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            while ((candidate = reader.readLine()) != null && candidate.length() != 0) {
                int i;
                StringTokenizer tok = new StringTokenizer(candidate);
                int numTerms = tok.countTokens();
                String[] terms = new String[numTerms];
                for (i = 0; i < numTerms; ++i) {
                    terms[i] = tok.nextToken();
                }
                for (i = 0; i < numTerms; ++i) {
                    int maxLen = synSearcher.identifyCandidate(terms[i]);
                    System.out.println("  max len starting with \"" + terms[i] + "\": " + maxLen);
                    int maxCheck = maxLen;
                    if (maxCheck + i > numTerms) {
                        maxCheck = numTerms - i;
                    }
                    StringBuffer termsSeq = new StringBuffer();
                    for (int j = maxCheck; j > 0; --j) {
                        termsSeq.setLength(0);
                        for (int k = 0; k < j; ++k) {
                            if (k > 0) {
                                termsSeq.append(' ');
                            }
                            termsSeq.append(terms[i + k]);
                        }
                        String[] synonyms = synSearcher.getSynonyms(termsSeq.toString(), true);
                        System.out.println("    synonyms for \"" + termsSeq.toString() + "\": ");
                        for (int k = 0; k < synonyms.length; ++k) {
                            System.out.println("      " + synonyms[k]);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

