/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.synonym.index;

import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.synonym.factory.SynonymGroup;
import com.ibm.es.nuvo.synonym.factory.SynonymGroups;
import com.ibm.es.nuvo.synonym.index.SynonymIndexReadException;
import com.ibm.es.nuvo.util.Base64;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;

public class SynonymIndexReader {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private File indexPath = null;
    private IndexReader indexReader = null;
    private SynonymGroups groups = null;

    private SynonymIndexReader(File synonymIndexPath) throws SynonymIndexReadException {
        this.init(synonymIndexPath);
    }

    private SynonymIndexReader(String cid) throws ConfigurationManagerException, SynonymIndexReadException {
        if (null == cid) {
            cid = "";
        }
        CollectionConfiguration collConfig = ConfigurationManager.getConfigurationManager().getCollection(cid);
        String synIndexPath = collConfig.getIndexPath(IndexDescriptor.IndexType.Synonym);
        this.init(new File(synIndexPath));
    }

    private void init(File synonymIndexPath) throws SynonymIndexReadException {
        this.indexPath = synonymIndexPath;
        try {
            this.indexReader = IndexReader.open((File)this.indexPath);
        }
        catch (IOException e) {
            throw new SynonymIndexReadException(e);
        }
    }

    public boolean isCurrent() throws SynonymIndexReadException {
        try {
            return this.indexReader.isCurrent();
        }
        catch (IOException e) {
            throw new SynonymIndexReadException(e);
        }
    }

    public SynonymGroup get(byte[] synonymGroupKey) throws SynonymIndexReadException {
        return this.getSynonymGroupFromIndex(synonymGroupKey);
    }

    public SynonymGroup get(String base64EncodedKey) throws SynonymIndexReadException {
        return this.getSynonymGroupFromIndex(base64EncodedKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynonymGroups getSynonymGroups() throws SynonymIndexReadException {
        SynonymGroup[] array = null;
        IndexReader indexReader = this.indexReader;
        synchronized (indexReader) {
            if (null == this.groups) {
                this.groups = this.createFromIndex();
            }
            array = this.groups.toArray();
        }
        return new SynonymGroups(array);
    }

    public void close() throws SynonymIndexReadException {
        try {
            this.indexReader.close();
        }
        catch (IOException e) {
            throw new SynonymIndexReadException(e);
        }
    }

    public void exportToXML(OutputStream outputStream) throws IOException, SynonymIndexReadException {
        SynonymGroups groupsToSerialize = this.getSynonymGroups();
        groupsToSerialize.serialize(outputStream);
    }

    public void exportToXML(OutputStream outputStream, String encoding) throws IOException, SynonymIndexReadException {
        SynonymGroups groupsToSerialize = this.getSynonymGroups();
        groupsToSerialize.serialize(outputStream, encoding);
    }

    private SynonymGroups createFromIndex() throws SynonymIndexReadException {
        SynonymGroups retGroups = new SynonymGroups(new SynonymGroup[0]);
        try {
            int maxDocs = this.indexReader.maxDoc();
            for (int i = 0; i < maxDocs; ++i) {
                Document doc;
                String[] values;
                if (this.indexReader.isDeleted(i) || null == (values = (doc = this.indexReader.document(i)).getValues("synStore"))) continue;
                retGroups.add(new SynonymGroup(values));
            }
        }
        catch (IOException e) {
            throw new SynonymIndexReadException(e);
        }
        return retGroups;
    }

    private SynonymGroup getSynonymGroupFromIndex(byte[] key) throws SynonymIndexReadException {
        if (null == key) {
            return null;
        }
        return this.getSynonymGroupFromIndex(Base64.encode(key));
    }

    private SynonymGroup getSynonymGroupFromIndex(String base64EncodedKey) throws SynonymIndexReadException {
        if (null == base64EncodedKey) {
            return null;
        }
        SynonymGroup retGroup = null;
        try {
            Term term = new Term("key", base64EncodedKey);
            TermDocs termDocs = this.indexReader.termDocs(term);
            while (termDocs.next()) {
                Document doc = this.indexReader.document(termDocs.doc());
                String[] values = doc.getValues("synStore");
                if (null == values) continue;
                retGroup = new SynonymGroup();
                for (int i = 0; i < values.length; ++i) {
                    retGroup.add(values[i]);
                }
            }
        }
        catch (IOException ioe) {
            throw new SynonymIndexReadException(ioe);
        }
        return retGroup;
    }

    public static SynonymIndexReader open(String cid) throws ConfigurationManagerException, SynonymIndexReadException {
        return new SynonymIndexReader(cid);
    }

    public static SynonymIndexReader open(File path) throws SynonymIndexReadException {
        return new SynonymIndexReader(path);
    }

    public static boolean indexExists(String cid) {
        if (null == cid) {
            cid = "";
        }
        CollectionConfiguration collConfig = null;
        try {
            collConfig = ConfigurationManager.getConfigurationManager().getCollection(cid);
            String synIndexPath = collConfig.getIndexPath(IndexDescriptor.IndexType.Synonym);
            return SynonymIndexReader.indexExists(new File(synIndexPath));
        }
        catch (ConfigurationManagerException configurationManagerException) {
            return false;
        }
    }

    public static boolean indexExists(File path) {
        return IndexReader.indexExists((File)path);
    }
}

