/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.synonym.factory;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.synonym.factory.SynonymGroup;
import com.ibm.es.nuvo.synonym.factory.SynonymGroupsSAXParseException;
import com.ibm.es.nuvo.util.XMLTagger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.TreeSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynonymGroups
extends TreeSet<SynonymGroup> {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = -235465083404805444L;
    public static final String Element_SynonymGroups = "synonymgroups";
    public static final String Attribute_version = "version";

    public SynonymGroups(SynonymGroup ... groups) {
        if (null != groups) {
            for (int i = 0; i < groups.length; ++i) {
                this.add(groups[i]);
            }
        }
    }

    @Override
    public boolean add(SynonymGroup group) {
        if (null == group || group.size() < 2) {
            return false;
        }
        return super.add(group);
    }

    public SynonymGroup replace(byte[] synonymGroupKey, SynonymGroup newGroup) {
        SynonymGroup group = this.remove(synonymGroupKey);
        if (null == group) {
            return null;
        }
        this.add(newGroup);
        return group;
    }

    public SynonymGroup remove(byte[] synonymGroupKey) {
        if (null == synonymGroupKey) {
            return null;
        }
        SynonymGroup groupToRemove = this.get(synonymGroupKey);
        if (null != groupToRemove && !super.remove(groupToRemove)) {
            groupToRemove = null;
        }
        return groupToRemove;
    }

    public SynonymGroup get(byte[] synonymGroupKey) {
        if (null == synonymGroupKey) {
            return null;
        }
        for (SynonymGroup curGroup : this) {
            if (!MessageDigest.isEqual(curGroup.getKey(), synonymGroupKey)) continue;
            return curGroup;
        }
        return null;
    }

    public String serialize() {
        XMLTagger tagger = new XMLTagger(true);
        tagger.startPI("xml");
        tagger.writeAttr(Attribute_version, "1.0");
        tagger.writeAttr("encoding", "UTF-8");
        tagger.endPI();
        tagger.openStartElement(Element_SynonymGroups);
        tagger.writeAttr(Attribute_version, "1.0");
        tagger.closeTag();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            tagger.writeText(((SynonymGroup)iterator.next()).serialize(), false);
        }
        tagger.writeText(System.getProperty("line.separator"), false);
        tagger.endElement(Element_SynonymGroups);
        return tagger.getXML();
    }

    public void serialize(OutputStream outStream) throws IOException {
        this.serialize(outStream, "UTF-8");
    }

    public void serialize(OutputStream outStream, String encoding) throws IOException {
        String result = this.serialize();
        byte[] bytes = result.getBytes(encoding);
        result = null;
        outStream.write(bytes);
    }

    public SynonymGroup[] toArray() {
        SynonymGroup[] array = new SynonymGroup[super.size()];
        return super.toArray(array);
    }

    public SynonymGroup[] toArray(SynonymGroup[] a) {
        return super.toArray(a);
    }

    public static SynonymGroups createFrom(InputStream is) throws SynonymGroupsSAXParseException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SynonymGroupsHandler handler = new SynonymGroupsHandler();
        SAXParser parser = null;
        try {
            parser = factory.newSAXParser();
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new SynonymGroupsSAXParseException(e);
        }
        ExtendedException ee = handler.getParseError();
        if (null != ee) {
            throw new SynonymGroupsSAXParseException(ee);
        }
        return handler.getSynonymGroups();
    }

    private static final class SynonymGroupsHandler
    extends DefaultHandler {
        private SynonymGroups groups = new SynonymGroups(new SynonymGroup[0]);
        private SynonymGroup curGroup = null;
        private boolean inSynonymElement = false;
        private ExtendedException parseError = null;

        public SynonymGroups getSynonymGroups() {
            return this.groups;
        }

        public ExtendedException getParseError() {
            return this.parseError;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (this.parseError != null) {
                return;
            }
            String elementName = localName;
            if (0 == elementName.length()) {
                elementName = qName;
            }
            if (elementName.equals("synonymgroup")) {
                this.curGroup = new SynonymGroup();
            } else if (elementName.equals("synonym")) {
                this.inSynonymElement = true;
            } else if (!elementName.equals(SynonymGroups.Element_SynonymGroups)) {
                this.parseError = new ExtendedException(new Message("S0023E.SYNONYM_INVALID_XML_ELEMENT", elementName));
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (this.parseError != null) {
                return;
            }
            String elementName = localName;
            if (0 == elementName.length()) {
                elementName = qName;
            }
            if (elementName.equals("synonymgroup")) {
                if (this.curGroup.size() < 2) {
                    Message errorMsg = new Message("A1483E.synonyms.more.than.one");
                    this.parseError = new ExtendedException(errorMsg);
                } else {
                    this.groups.add(this.curGroup);
                    this.curGroup = null;
                }
            } else if (elementName.equals("synonym")) {
                this.inSynonymElement = false;
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.parseError != null) {
                return;
            }
            if (this.inSynonymElement && null != this.curGroup && length > 0) {
                String s = new String(ch, start, length).trim();
                this.curGroup.add(s);
            }
        }
    }
}

