/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.synonym.factory;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.normalizer.NormalizedStringBuffer;
import com.ibm.es.nuvo.normalizer.NormalizedStringBufferType1;
import com.ibm.es.nuvo.util.Base64;
import com.ibm.es.nuvo.util.HashUtils;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseException;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynonymGroup
extends TreeSet<String>
implements Comparable<SynonymGroup>,
Externalizable {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = 7139266052791815029L;
    public static final String Element_Synonym = "synonym";
    public static final String Element_SynonymGroup = "synonymgroup";
    private static final String PARSE_TREE_PATH = "/synonymgroup/synonym/";
    private String toString = null;
    private byte[] key = null;
    private String base64EncodedKey = null;
    private NormalizedStringBuffer normalizer = new NormalizedStringBufferType1();

    public SynonymGroup() {
    }

    public SynonymGroup(String ... synonyms) {
        if (null != synonyms) {
            for (int i = 0; i < synonyms.length; ++i) {
                this.add(synonyms[i]);
            }
        }
    }

    private synchronized void resetCachedInstances() {
        this.toString = null;
        this.key = null;
        this.base64EncodedKey = null;
    }

    @Override
    public synchronized boolean add(String synonym) {
        boolean retValue = false;
        if (null == synonym) {
            return false;
        }
        if ((synonym = synonym.trim()).length() == 0) {
            return false;
        }
        this.normalizer.setLength(0);
        this.normalizer.append(synonym);
        retValue = super.add(this.normalizer.toString());
        this.resetCachedInstances();
        return retValue;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends String> c) {
        if (null == c) {
            return false;
        }
        boolean retValue = false;
        for (String string : c) {
            retValue |= this.add(string);
        }
        this.resetCachedInstances();
        return retValue;
    }

    @Override
    public synchronized boolean remove(Object synonym) {
        boolean retValue = super.remove(synonym);
        this.resetCachedInstances();
        return retValue;
    }

    public String serialize() {
        XMLTagger tagger = new XMLTagger(true);
        tagger.openStartElement(Element_SynonymGroup);
        tagger.closeTag();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            tagger.openStartElement(Element_Synonym);
            tagger.closeTag();
            tagger.writeText((String)iterator.next());
            tagger.endElement(Element_Synonym);
        }
        tagger.endElement(Element_SynonymGroup);
        return tagger.getXML();
    }

    public void serialize(OutputStream outStream) throws IOException {
        this.serialize(outStream, "UTF-8");
    }

    public void serialize(OutputStream outStream, String encoding) throws IOException {
        String result = this.serialize();
        byte[] bytes = result.getBytes(encoding);
        result = null;
        outStream.write(bytes);
    }

    public String[] toArray() {
        String[] array = new String[super.size()];
        return super.toArray(array);
    }

    public String[] toArray(String[] a) {
        return super.toArray(a);
    }

    @Override
    public synchronized String toString() {
        if (null == this.toString) {
            StringBuilder builder = new StringBuilder();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                builder.append('[');
                builder.append((String)iterator.next());
                builder.append(']');
                builder.append(' ');
            }
            this.toString = builder.substring(0, builder.length() - 1);
        }
        return this.toString;
    }

    public synchronized byte[] getKey() {
        if (null == this.key) {
            try {
                this.key = HashUtils.md5(this.toString());
            }
            catch (ExtendedException ee) {
                Loggers.logger.log(Level.WARNING, ee);
                return null;
            }
        }
        byte[] retKey = new byte[this.key.length];
        System.arraycopy(this.key, 0, retKey, 0, this.key.length);
        return retKey;
    }

    public synchronized String getBase64Key() {
        if (null == this.base64EncodedKey) {
            this.base64EncodedKey = Base64.encode(this.getKey());
        }
        return this.base64EncodedKey;
    }

    @Override
    public boolean equals(Object o) {
        boolean retValue = false;
        if (o instanceof SynonymGroup) {
            retValue = MessageDigest.isEqual(this.getKey(), ((SynonymGroup)o).getKey());
        }
        return retValue;
    }

    @Override
    public int compareTo(SynonymGroup o) {
        String oToCompare = "";
        if (null != o) {
            oToCompare = o.toString();
        }
        return this.toString().compareTo(oToCompare);
    }

    public static SynonymGroup createFrom(InputStream is) throws ParseException {
        Parser parser = new Parser();
        ParseTree tree = new ParseTree();
        tree.addPath(PARSE_TREE_PATH, "add", String.class);
        SynonymGroup group = new SynonymGroup();
        parser.parse(is, tree, group);
        return group;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }
}

