/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.status;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.httplistener.ContextType;
import com.ibm.es.nuvo.indexer.IndexerMonitor;
import com.ibm.es.nuvo.jvm.JvmSupportManager;
import com.ibm.es.nuvo.status.CollectionStatus;
import com.ibm.es.nuvo.status.CrawlerStatus;
import com.ibm.es.nuvo.status.DocQueueStatus;
import com.ibm.es.nuvo.status.JvmStatus;
import com.ibm.es.nuvo.util.XMLTagger;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusRouter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String ReleaseNameElement = "releaseName";
    private static final String ReleaseFileElement = "releaseFile";
    private static final String ReleaseJarFileElement = "releaseJarFile";
    private static final String StatusElement = "status";

    public static String processStatusRequest(String contextPath, Hashtable<String, String> parms, boolean authenticated) {
        String results = null;
        String statusAction = parms.get("statusAction");
        results = statusAction != null ? ("runGC".equalsIgnoreCase(statusAction) ? StatusRouter.runGarbageCollector(parms, authenticated) : ("heapDump".equalsIgnoreCase(statusAction) ? StatusRouter.takeHeapDump(authenticated) : StatusRouter.buildXMLCommandStatusDoc("Unknown status action \"" + statusAction + "\".  Only heapDump and runGC are supported."))) : StatusRouter.getGlobalStatus(parms);
        return results;
    }

    public static String getGlobalStatus(Hashtable<String, String> parms) {
        String strCollectionDetails;
        boolean jvmOnly = false;
        boolean getErrorDocs = false;
        String strJvmOnly = parms.get("jvmOnly");
        if (strJvmOnly != null) {
            jvmOnly = strJvmOnly.equalsIgnoreCase("true");
        }
        if ((strCollectionDetails = parms.get("collectionDetails")) != null) {
            getErrorDocs = strCollectionDetails.equalsIgnoreCase("true");
        }
        GlobalSystem globalSystem = GlobalSystem.getSingleInstance();
        String lineEnd = System.getProperty("line.separator");
        XMLTagger tagger = new XMLTagger(true, 150000);
        tagger.openStartElement(StatusElement);
        tagger.writeAttr("version", "2.0");
        tagger.closeTag();
        tagger.startElement("time");
        DateFormat df = DateFormat.getDateTimeInstance();
        String strTime = df.format(new Date());
        tagger.writeText(strTime);
        tagger.endElement("time");
        if (jvmOnly) {
            JvmStatus.getStatus(tagger);
        } else {
            ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
            tagger.startElement(ReleaseNameElement);
            tagger.writeText(releaseInfo.getReleaseName());
            tagger.endElement(ReleaseNameElement);
            tagger.startElement(ReleaseFileElement);
            tagger.writeText(releaseInfo.getReleaseFileName());
            tagger.endElement(ReleaseFileElement);
            String releaseJarFile = releaseInfo.getReleaseJarFileName();
            if (releaseJarFile != null && releaseJarFile.length() > 0) {
                tagger.startElement(ReleaseJarFileElement);
                tagger.writeText(releaseJarFile);
                tagger.endElement(ReleaseJarFileElement);
            }
            DocQueueStatus.getStatus(tagger, false);
            JvmStatus.getStatus(tagger);
            CollectionStatus.getStatus(tagger, getErrorDocs);
            CrawlerStatus.getStatus(tagger);
            IndexerMonitor mon = globalSystem.getIndexerMonitor();
            if (mon != null) {
                mon.getStatus(tagger);
            }
        }
        tagger.endElement(StatusElement);
        String baseXML = tagger.getXML();
        StringBuilder sb = new StringBuilder(baseXML.length() + 1500);
        XMLTagger tagger2 = new XMLTagger(true);
        tagger2.startPI("xml");
        tagger2.writeAttr("version", "1.0");
        tagger2.writeAttr("encoding", "UTF-8");
        tagger2.endPI();
        sb.append(tagger2.getXML());
        sb.append(lineEnd);
        String context = ContextType.ResourceStylesheets.getContextPath();
        String fullContext = context + "/globalStatus.xsl";
        sb.append("<?xml-stylesheet type=\"text/xsl\" href=\"" + fullContext + "\"?>");
        sb.append(lineEnd);
        sb.append(baseXML);
        sb.append(lineEnd);
        return sb.toString();
    }

    protected static String runGarbageCollector(Hashtable<String, String> parms, boolean authenticated) {
        String returnDoc = null;
        if (authenticated) {
            System.out.println("Taking gc");
            System.gc();
            returnDoc = StatusRouter.getGlobalStatus(parms);
        } else {
            returnDoc = StatusRouter.buildXMLCommandStatusDoc("Function runGC not allowed through /api/monitor context.  Use the /api/admin context instead.");
        }
        return returnDoc;
    }

    protected static String takeHeapDump(boolean authenticated) {
        String returnDoc = null;
        if (authenticated) {
            try {
                JvmSupportManager.getJvmSupportInterface().takeHeapDump();
            }
            catch (Exception e) {
                return StatusRouter.buildXMLCommandStatusDoc("HeapDump " + e.toString());
            }
            returnDoc = StatusRouter.buildXMLCommandStatusDoc("HeapDump successfully taken");
        } else {
            returnDoc = StatusRouter.buildXMLCommandStatusDoc("Function heapDump not allowed through /api/monitor context.  Use the /api/admin context instead.");
        }
        return returnDoc;
    }

    private static String buildXMLCommandStatusDoc(String status) {
        String lineEnd = System.getProperty("line.separator");
        XMLTagger tagger = new XMLTagger(true);
        tagger.startElement(StatusElement);
        tagger.writeText(status);
        tagger.endElement(StatusElement);
        String baseXML = tagger.getXML();
        StringBuilder sb = new StringBuilder(2000);
        XMLTagger tagger2 = new XMLTagger(true);
        tagger2.startPI("xml");
        tagger2.writeAttr("version", "1.0");
        tagger2.writeAttr("encoding", "UTF-8");
        tagger2.endPI();
        sb.append(tagger2.getXML());
        sb.append(lineEnd);
        String context = ContextType.ResourceStylesheets.getContextPath();
        String fullContext = context + "/commandResult.xsl";
        sb.append("<?xml-stylesheet type=\"text/xsl\" href=\"" + fullContext + "\"?>");
        sb.append(lineEnd);
        sb.append(baseXML);
        sb.append(lineEnd);
        return sb.toString();
    }
}

