/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.status;

import com.ibm.es.nuvo.util.XMLTagger;
import java.util.Map;
import java.util.Set;

public class JvmStatus {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String JvmElement = "jvm";
    private static final String HeapSizeElement = "heap_size";
    private static final String HeapUsedElement = "heap_used";
    private static final String ThreadsElement = "threads";
    private static final String ThreadElement = "thread";
    private static final String ThreadNameElement = "name";
    private static final String ThreadStackElement = "stack";
    private static final String ThreadStackFrameElement = "sf";
    private static final String ThreadStackFrameTextElement = "txt";

    public static void getStatus(XMLTagger tagger) {
        long freeMemory = Runtime.getRuntime().freeMemory();
        long heapSize = Runtime.getRuntime().totalMemory();
        tagger.startElement(JvmElement);
        tagger.startElement(HeapSizeElement);
        tagger.writeText(Long.toString(heapSize));
        tagger.endElement(HeapSizeElement);
        tagger.startElement(HeapUsedElement);
        tagger.writeText(Long.toString(heapSize - freeMemory));
        tagger.endElement(HeapUsedElement);
        tagger.startElement(ThreadsElement);
        Map<Thread, StackTraceElement[]> stacks = Thread.getAllStackTraces();
        Set<Thread> threads = stacks.keySet();
        for (Thread t : threads) {
            StackTraceElement[] stack = stacks.get(t);
            tagger.startElement(ThreadElement);
            tagger.startElement(ThreadNameElement);
            tagger.writeText(t.getName());
            tagger.endElement(ThreadNameElement);
            if (stack != null) {
                tagger.startElement(ThreadStackElement);
                for (int i = 0; i < stack.length; ++i) {
                    tagger.startElement(ThreadStackFrameElement);
                    tagger.startElement(ThreadStackFrameTextElement);
                    tagger.writeText(stack[i].toString());
                    tagger.endElement(ThreadStackFrameTextElement);
                    tagger.endElement(ThreadStackFrameElement);
                }
                tagger.endElement(ThreadStackElement);
            }
            tagger.endElement(ThreadElement);
        }
        tagger.endElement(ThreadsElement);
        tagger.endElement(JvmElement);
    }
}

