/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.status;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInterface;
import com.ibm.es.nuvo.util.XMLTagger;
import java.util.Vector;

public class DocQueueStatus {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String DocQueueElement = "doc_queue";
    private static final String NumDocsElement = "num_docs_on_queue";
    private static final String QueueContentsElement = "contents";
    private static final String DocumentElement = "doc";
    private static final String CollectionIdElement = "collection";
    private static final String InBatchElement = "in_batch";
    private static final String DocTypeElement = "type";
    private static final String DocURIElement = "uri";
    private static final String TotalDocsElement = "total_docs_processed";

    public static void getStatus(XMLTagger tagger, boolean showDocsOnQueue) {
        DocumentQueueInterface docQueue = GlobalSystem.getSingleInstance().getDocumentQueue();
        Vector<String> collectionIds = new Vector<String>();
        Vector<Boolean> docInBatchList = new Vector<Boolean>();
        Vector<String> docTypes = new Vector<String>();
        Vector<String> docURIs = new Vector<String>();
        int numDocs = docQueue.getCounter();
        docQueue.getStatus(collectionIds, docInBatchList, docURIs, docTypes, null);
        tagger.startElement(DocQueueElement);
        if (collectionIds.size() > 0) {
            tagger.startElement(QueueContentsElement);
            for (int i = 0; i < collectionIds.size(); ++i) {
                tagger.startElement(DocumentElement);
                tagger.startElement(CollectionIdElement);
                tagger.writeText(collectionIds.elementAt(i));
                tagger.endElement(CollectionIdElement);
                tagger.startElement(DocTypeElement);
                String fullClassName = docTypes.elementAt(i);
                int indexOfLastDot = fullClassName.lastIndexOf(46);
                String className = fullClassName;
                if (indexOfLastDot > 0 && indexOfLastDot - 1 < fullClassName.length()) {
                    className = fullClassName.substring(indexOfLastDot + 1);
                }
                tagger.writeText(className);
                tagger.endElement(DocTypeElement);
                tagger.startElement(InBatchElement);
                tagger.writeText(docInBatchList.elementAt(i).toString());
                tagger.endElement(InBatchElement);
                tagger.startElement(DocURIElement);
                tagger.writeText(docURIs.elementAt(i));
                tagger.endElement(DocURIElement);
                tagger.endElement(DocumentElement);
            }
            tagger.endElement(QueueContentsElement);
        }
        tagger.startElement(NumDocsElement);
        tagger.writeText(Integer.toString(numDocs));
        tagger.endElement(NumDocsElement);
        tagger.startElement(TotalDocsElement);
        tagger.writeText(Long.toString(docQueue.getTotalDocsProcessed()));
        tagger.endElement(TotalDocsElement);
        tagger.endElement(DocQueueElement);
    }
}

