/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.status;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.util.XMLTagger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;

public class CrawlerStatus {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String WebCrawlerStatusElement = "web_crawler";
    private static final String LineElement = "l1";
    private static final String Line2Element = "l2";

    public static void getStatus(XMLTagger tagger) {
        GlobalSystem globalSystem = GlobalSystem.getSingleInstance();
        String webStatus = "Does not exist";
        if (globalSystem.getWebCrawler() != null) {
            try {
                webStatus = globalSystem.getWebCrawler().takeSnapshot();
            }
            catch (Exception e) {
                StringWriter strWriter = new StringWriter();
                PrintWriter pw = new PrintWriter(strWriter);
                pw.append("Exception when fetching status: ");
                pw.append(e.toString());
                e.printStackTrace(pw);
                pw.close();
                webStatus = strWriter.getBuffer().toString();
            }
        }
        tagger.startElement(WebCrawlerStatusElement);
        CrawlerStatus.writeLinesToXML(tagger, webStatus);
        tagger.endElement(WebCrawlerStatusElement);
    }

    private static void writeLinesToXML(XMLTagger tagger, String data) {
        int count = 0;
        if (data != null && data.length() > 0) {
            StringTokenizer st = new StringTokenizer(data, "\n");
            while (st.hasMoreTokens()) {
                tagger.startElement(LineElement);
                tagger.startElement(Line2Element);
                tagger.writeText(st.nextToken());
                tagger.endElement(Line2Element);
                tagger.endElement(LineElement);
                ++count;
            }
        }
    }
}

