/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.status;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.api.CrawlService;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.CrawlServiceFactory;
import com.ibm.es.nuvo.crawler.GlobalCrawlerManager;
import com.ibm.es.nuvo.crawler.admin.CrawlSpaceControl;
import com.ibm.es.nuvo.crawler.admin.CrawlerControl;
import com.ibm.es.nuvo.crawler.admin.CrawlerManager;
import com.ibm.es.nuvo.indexer.IndexerMonitor;
import com.ibm.es.nuvo.search.QueryImpl;
import com.ibm.es.nuvo.search.SearchServiceImpl;
import com.ibm.es.nuvo.search.SearchableImpl;
import com.ibm.es.nuvo.util.Constants;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.siapi.common.ApplicationInfo;
import com.ibm.siapi.search.Query;
import com.ibm.siapi.search.ResultSet;
import com.ibm.siapi.search.Searchable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionStatus {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String CollectionsElement = "collections";
    private static final String CollectionElement = "collection";
    private static final String IdElement = "id";
    private static final String NumDocsElement = "num_docs";
    private static final String NumDeletedDocsElement = "num_deleted_docs";
    private static final String NumErrorDocsElement = "num_error_docs";
    private static final String ByteSizeElement = "byte_size";
    private static final String CollectionStateElement = "state";
    private static final String CrawlersElement = "crawlers";
    private static final String CrawlerElement = "crawler";
    private static final String CrawlerNameElement = "name";
    private static final String CrawlerTypeElement = "type";
    private static final String CrawlSpaceElement = "crawlspace";
    private static final String CrawlSpacesElement = "crawlspaces";
    private static final String CrawlSpaceNameElement = "name";
    private static final String CrawlSpaceStateElement = "state";
    private String id = null;
    private Vector<CrawlerInfo> crawlersInfo = new Vector();
    private String state = "N/A";
    private long numDocs = 0L;
    private long numDeletedDocs = 0L;
    private long numErrorDocs = -1L;
    private long byteSize = 0L;

    public static void getStatus(XMLTagger tagger, boolean getErrorDocs) {
        CollectionStatus status;
        String collectionId;
        int i;
        ConfigurationManager configMgr = ConfigurationManager.getConfigurationManager();
        Vector<String> collectionIds = configMgr.getCollectionIds((CollectionConfiguration.State)null);
        HashMap<String, CollectionStatus> collectionStatusSet = new HashMap<String, CollectionStatus>();
        for (i = 0; i < collectionIds.size(); ++i) {
            collectionId = collectionIds.elementAt(i);
            status = new CollectionStatus(collectionId);
            collectionStatusSet.put(collectionId, status);
        }
        CollectionStatus.getCollectionsProperties(collectionStatusSet, getErrorDocs);
        tagger.startElement(CollectionsElement);
        for (i = 0; i < collectionIds.size(); ++i) {
            collectionId = collectionIds.elementAt(i);
            status = collectionStatusSet.get(collectionId);
            status.writeTo(tagger);
        }
        tagger.endElement(CollectionsElement);
    }

    private CollectionStatus(String collectionId) {
        this.id = collectionId;
    }

    public void setByteSize(long byteSize) {
        this.byteSize = byteSize;
    }

    public void setNumDocs(long numDocs) {
        this.numDocs = numDocs;
    }

    public void setNumDeletedDocs(long numDeletedDocs) {
        this.numDeletedDocs = numDeletedDocs;
    }

    public void writeTo(XMLTagger tagger) {
        tagger.startElement(CollectionElement);
        tagger.startElement(IdElement);
        tagger.writeText(this.id);
        tagger.endElement(IdElement);
        tagger.startElement(NumDocsElement);
        tagger.writeText(Long.toString(this.numDocs));
        tagger.endElement(NumDocsElement);
        tagger.startElement(NumDeletedDocsElement);
        tagger.writeText(Long.toString(this.numDeletedDocs));
        tagger.endElement(NumDeletedDocsElement);
        if (this.numErrorDocs >= 0L) {
            tagger.startElement(NumErrorDocsElement);
            tagger.writeText(Long.toString(this.numErrorDocs));
            tagger.endElement(NumErrorDocsElement);
        }
        tagger.startElement(ByteSizeElement);
        tagger.writeText(Long.toString(this.byteSize));
        tagger.endElement(ByteSizeElement);
        tagger.startElement("state");
        tagger.writeText(this.state);
        tagger.endElement("state");
        if (this.crawlersInfo.size() > 0) {
            tagger.startElement(CrawlersElement);
            for (int i = 0; i < this.crawlersInfo.size(); ++i) {
                CrawlerInfo crawlerInfo = this.crawlersInfo.get(i);
                tagger.startElement(CrawlerElement);
                tagger.startElement("name");
                tagger.writeText(crawlerInfo.name);
                tagger.endElement("name");
                tagger.startElement(CrawlerTypeElement);
                tagger.writeText(crawlerInfo.type);
                tagger.endElement(CrawlerTypeElement);
                if (crawlerInfo.crawlspaceToState.size() > 0) {
                    tagger.startElement(CrawlSpacesElement);
                    Set<Map.Entry<String, String>> s = crawlerInfo.crawlspaceToState.entrySet();
                    for (Map.Entry<String, String> entry : s) {
                        tagger.startElement(CrawlSpaceElement);
                        tagger.startElement("name");
                        tagger.writeText(entry.getKey());
                        tagger.endElement("name");
                        tagger.startElement("state");
                        tagger.writeText(entry.getValue());
                        tagger.endElement("state");
                        tagger.endElement(CrawlSpaceElement);
                    }
                    tagger.endElement(CrawlSpacesElement);
                }
                tagger.endElement(CrawlerElement);
            }
            tagger.endElement(CrawlersElement);
        }
        tagger.endElement(CollectionElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getCollectionsProperties(HashMap<String, CollectionStatus> statusSet, boolean getErrorDocs) {
        IndexerMonitor mon = GlobalSystem.getSingleInstance().getIndexerMonitor();
        ConfigurationManager cfgMgr = ConfigurationManager.getConfigurationManager();
        if (mon != null) {
            for (Map.Entry<String, CollectionStatus> curEntry : statusSet.entrySet()) {
                String collectionId = curEntry.getKey();
                CollectionStatus status = curEntry.getValue();
                CollectionConfiguration collection = null;
                try {
                    collection = cfgMgr.getCollection(collectionId, (CollectionConfiguration.State)null);
                    status.state = collection.getState().toString();
                }
                catch (Exception e) {
                    status.state = CollectionStatus.getExceptionAsString(e);
                    e.printStackTrace();
                }
                if (collection == null || !collection.isInState(ConfigurationManager.DefaultAccessableStates)) continue;
                try {
                    mon.flushStatisticsFor(collectionId);
                    status.setNumDocs(mon.getNumberOfDocuments(collectionId));
                    status.setNumDeletedDocs(mon.getNumberOfDeletedDocuments(collectionId));
                    status.setByteSize(mon.getIndexSize(collectionId));
                }
                catch (Exception e) {
                    // empty catch block
                }
                CollectionStatus.getCrawlerInfoForCollection(collectionId, status.crawlersInfo);
                if (!getErrorDocs) continue;
                Searchable searchable = null;
                try {
                    ApplicationInfo appInfo = null;
                    searchable = SearchServiceImpl.getInstance().getSearchable(appInfo, collectionId);
                    QueryImpl query = new QueryImpl();
                    query.setText("_code:* -_code:200");
                    ResultSet rs = searchable.search((Query)query);
                    status.numErrorDocs = rs.getEstimatedNumberOfResults();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (searchable == null) continue;
                    try {
                        SearchServiceImpl.getInstance().putSearchable((SearchableImpl)searchable);
                    }
                    catch (ExtendedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static void getCrawlerInfoForCollection(String collectionId, Vector<CrawlerInfo> crawlerInfoList) {
        CrawlerManager crwMgr;
        GlobalCrawlerManager crawlerMgr = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        CrawlService webCrawlService = CrawlServiceFactory.getInstance().getServiceFor(Constants.CrawlerType.Web);
        CrawlerInfo webCrawlerInfo = new CrawlerInfo("web", "web");
        if (webCrawlService != null) {
            String crawlSpaceId = CollectionConfiguration.collectionIdToCrawlspaceId(Constants.CrawlerType.Web, collectionId);
            if (webCrawlService.crawlspaceExistsForCollection(collectionId)) {
                try {
                    boolean crawling = webCrawlService.isCrawling(crawlSpaceId);
                    if (crawling) {
                        webCrawlerInfo.crawlspaceToState.put("", "crawling");
                    } else {
                        webCrawlerInfo.crawlspaceToState.put("", "stopped");
                    }
                    crawlerInfoList.add(webCrawlerInfo);
                }
                catch (ExtendedException e) {
                    webCrawlerInfo.crawlspaceToState.put("", CollectionStatus.getExceptionAsString(e));
                    crawlerInfoList.add(webCrawlerInfo);
                }
            }
        }
        if ((crwMgr = crawlerMgr.getCrawlerManager(collectionId)) != null) {
            try {
                CrawlerControl[] crwCtrls = crwMgr.getAvailableCrawlerControls();
                for (int j = 0; j < crwCtrls.length; ++j) {
                    String crawlerId = crwCtrls[j].getID();
                    String crawlerName = crwCtrls[j].getName();
                    String crawlerType = crwCtrls[j].getType();
                    CrawlerInfo crawlerInfo = new CrawlerInfo(crawlerName, crawlerType);
                    try {
                        CrawlSpaceControl[] crwSpaceCtrls = crwMgr.getAvailableCrawlSpaceControls(crawlerId);
                        for (int k = 0; k < crwSpaceCtrls.length; ++k) {
                            String crawlSpaceName = crwSpaceCtrls[k].getName();
                            String crawlSpaceStatus = "";
                            try {
                                crawlSpaceStatus = crwSpaceCtrls[k].getCrawlSpaceStatus().getStatus().toString();
                            }
                            catch (Exception e) {
                                crawlSpaceStatus = CollectionStatus.getExceptionAsString(e);
                            }
                            crawlerInfo.crawlspaceToState.put(crawlSpaceName, crawlSpaceStatus);
                        }
                    }
                    catch (Exception e) {
                        crawlerInfo.crawlspaceToState.put("Error" + System.currentTimeMillis(), CollectionStatus.getExceptionAsString(e));
                    }
                    if (crawlerInfo.crawlspaceToState.size() <= 0) continue;
                    crawlerInfoList.add(crawlerInfo);
                }
            }
            catch (Exception e) {
                CrawlerInfo crawlerInfo = new CrawlerInfo("Error", "Error");
                crawlerInfoList.add(crawlerInfo);
                crawlerInfo.crawlspaceToState.put("Error", CollectionStatus.getExceptionAsString(e));
            }
        }
    }

    private static String getExceptionAsString(Exception e) {
        String strTrace = e.getClass().getName() + " at ";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        e.printStackTrace(pw);
        pw.close();
        try {
            bos.close();
            strTrace = new String(bos.toByteArray());
        }
        catch (IOException e1) {
            // empty catch block
        }
        return strTrace;
    }

    public static class CrawlerInfo {
        public String name = "";
        public String type = "";
        public HashMap<String, String> crawlspaceToState = new HashMap();

        public CrawlerInfo(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }
}

