/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.spell.querylog;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.logging.CompactLogRecordIterator;
import com.ibm.es.nuvo.logging.LoggedQuery;
import com.ibm.es.nuvo.logging.SessionDetails;
import com.ibm.es.nuvo.logging.SessionList;
import com.ibm.es.nuvo.spell.querylog.BoundedRecentWordSet;
import com.ibm.es.nuvo.spell.querylog.DictionaryWord;
import com.ibm.es.nuvo.spell.querylog.QueryLogReport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.LogRecord;

public class SessionLogReport {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private ReportType currentReport;
    private String cid = null;
    private int numberOfItemsInReport = 0;
    private String queryText = null;
    private BoundedRecentWordSet sessionListResultSet = null;
    private TreeMap<String, SessionList> sessionListResults = null;
    private TreeSet<String> sessionListForQuery = null;
    private String sessionId = null;
    private BoundedRecentWordSet sessionDetailsResultSet = null;
    private TreeMap<String, SessionDetails> sessionDetailsResults = null;

    private SessionLogReport(int numberOfItemsInReport, String cid, ReportType curRep) {
        this.numberOfItemsInReport = numberOfItemsInReport;
        this.cid = cid;
        this.currentReport = curRep;
        if (this.currentReport == ReportType.SESSION_LIST) {
            this.sessionListResultSet = new BoundedRecentWordSet(this.numberOfItemsInReport, true);
            this.sessionListResults = new TreeMap();
            this.sessionListForQuery = new TreeSet();
        }
        if (this.currentReport == ReportType.SESSION_DETAILS) {
            this.sessionDetailsResultSet = new BoundedRecentWordSet(this.numberOfItemsInReport, false);
            this.sessionDetailsResults = new TreeMap();
        }
    }

    public String getQueryText() {
        return this.queryText;
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public DictionaryWord[] getSessionList() {
        if (null == this.sessionListResultSet) {
            return new DictionaryWord[0];
        }
        return this.sessionListResultSet.getWords();
    }

    public DictionaryWord[] getSessionDetails() {
        if (null == this.sessionDetailsResultSet) {
            return new DictionaryWord[0];
        }
        return this.sessionDetailsResultSet.getWords();
    }

    public static SessionLogReport generateSessionListReport(int numberOfItemsInReport, File[] queryLogFiles, String cid, String queryText) throws ExtendedException {
        SessionLogReport sessionReport = new SessionLogReport(numberOfItemsInReport, cid, ReportType.SESSION_LIST);
        sessionReport.setQueryText(queryText);
        sessionReport.analyzeQueryLog(queryLogFiles);
        sessionReport.processSessionListResults();
        return sessionReport;
    }

    public static SessionLogReport generateSessionDetailsReport(int numberOfItemsInReport, File[] queryLogFiles, String cid, String sessionId) throws ExtendedException {
        SessionLogReport sessionReport = new SessionLogReport(numberOfItemsInReport, cid, ReportType.SESSION_DETAILS);
        sessionReport.setSessionId(sessionId);
        sessionReport.analyzeQueryLog(queryLogFiles);
        sessionReport.processSessionDetailsResults();
        return sessionReport;
    }

    private void analyzeQueryLog(File[] queryLogFiles) throws ExtendedException {
        if (null == queryLogFiles) {
            throw new ExtendedException(new Message("G0035E.FILE_NOT_EXIST", "null"));
        }
        for (File queryLogFile : queryLogFiles) {
            this.analyzeQueryLog(queryLogFile);
        }
    }

    private void analyzeQueryLog(File queryLogFile) throws ExtendedException {
        if (null == queryLogFile) {
            throw new ExtendedException(new Message("G0035E.FILE_NOT_EXIST", "null"));
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(queryLogFile);
            this.analyzeQueryLog(fis);
            try {
                fis.close();
            }
            catch (IOException e) {
                throw new ExtendedException(e);
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new ExtendedException(new Message("G0035E.FILE_NOT_EXIST", queryLogFile.getAbsolutePath()), (Throwable)fnfe);
        }
    }

    private void analyzeQueryLog(InputStream is) {
        this.analyzeQueryLog(new CompactLogRecordIterator(is));
    }

    private void analyzeQueryLog(CompactLogRecordIterator iterator) {
        while (iterator.hasNext()) {
            LogRecord logRecord = iterator.next();
            if (null == logRecord) continue;
            try {
                LoggedQuery loggedQuery = new LoggedQuery(logRecord);
                if (this.currentReport == ReportType.SESSION_LIST && this.queryText != null) {
                    boolean keepLogRecord = false;
                    long timeStamp = loggedQuery.getTimeStamp();
                    String logSessionId = loggedQuery.getSessionId();
                    String logQueryText = "";
                    if (loggedQuery.getCollectionID().equals(this.cid)) {
                        if (loggedQuery.isQueryRecord()) {
                            logQueryText = DictionaryWord.normalizeQueryWords(loggedQuery.getQueryText());
                            keepLogRecord = true;
                        }
                        if (loggedQuery.isClickedResultRecord()) {
                            keepLogRecord = true;
                        }
                    }
                    if (keepLogRecord) {
                        SessionList sl;
                        if (this.sessionListResults.containsKey(logSessionId)) {
                            sl = this.sessionListResults.get(logSessionId);
                            if (timeStamp < sl.starttime) {
                                sl.starttime = timeStamp;
                                sl.initialQuery = logQueryText;
                            }
                            if (timeStamp > sl.endtime) {
                                sl.endtime = timeStamp;
                            }
                        } else {
                            sl = new SessionList(timeStamp, timeStamp, logQueryText);
                            this.sessionListResults.put(logSessionId, sl);
                        }
                        if (logQueryText.equalsIgnoreCase(this.queryText)) {
                            this.sessionListForQuery.add(logSessionId);
                        }
                    }
                }
                if (this.currentReport != ReportType.SESSION_DETAILS || this.sessionId == null || !loggedQuery.getSessionId().equals(this.sessionId) || !loggedQuery.getCollectionID().equals(this.cid)) continue;
                long timeStamp = loggedQuery.getTimeStamp();
                String userAction = "";
                String queryTerm = "";
                String topClickedTitle = "";
                String topClickedResult = "";
                if (loggedQuery.isQueryRecord()) {
                    userAction = "query";
                    queryTerm = DictionaryWord.normalizeQueryWords(loggedQuery.getQueryText());
                }
                if (loggedQuery.isClickedResultRecord()) {
                    userAction = "click";
                    topClickedTitle = loggedQuery.getResultTitle();
                    String baseUrl = QueryLogReport.parseBaseUrl(loggedQuery.getClickedResult());
                    topClickedResult = QueryLogReport.getClickableUrl(loggedQuery.getClickedResult(), baseUrl, this.cid, loggedQuery.getCharset(), loggedQuery.getMimeType(), loggedQuery.getSpaceId());
                }
                SessionDetails sd = new SessionDetails(timeStamp, userAction, queryTerm, topClickedTitle, topClickedResult);
                this.sessionDetailsResults.put(String.valueOf(timeStamp), sd);
            }
            catch (Throwable throwable) {}
        }
    }

    private void processSessionListResults() {
        Set<String> tempKeySet = this.sessionListResults.keySet();
        Iterator<String> it = tempKeySet.iterator();
        while (it.hasNext()) {
            if (this.sessionListForQuery.contains(it.next())) continue;
            it.remove();
        }
        Set<Map.Entry<String, SessionList>> tempEntrySet = this.sessionListResults.entrySet();
        for (Map.Entry<String, SessionList> entry : tempEntrySet) {
            String si = entry.getKey();
            SessionList sl = entry.getValue();
            this.sessionListResultSet.add(new DictionaryWord(si, sl.starttime, sl.endtime - sl.starttime, sl.initialQuery));
        }
        this.sessionListResults.clear();
    }

    private void processSessionDetailsResults() {
        Set<Map.Entry<String, SessionDetails>> tempEntrySet = this.sessionDetailsResults.entrySet();
        for (Map.Entry<String, SessionDetails> entry : tempEntrySet) {
            SessionDetails sd = entry.getValue();
            this.sessionDetailsResultSet.add(new DictionaryWord(sd.datetime, sd.userAction, sd.queryTerm, sd.topClickedTitle, sd.topClickedResult));
        }
        this.sessionDetailsResults.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReportType {
        SESSION_LIST,
        SESSION_DETAILS;

    }
}

