/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.spell.querylog;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.logging.LoggedQuery;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.spell.querylog.QueryCount;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;

public class QueryRuntimeStatistics {
    private Hashtable<String, CollectionStatistic> collectionStats;
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String QueryCountFileName = "_vs143ts.fiz";
    private File queryCountFile;
    private File replacedQueryCountFile;
    private QueryCount todaysQueryCount;
    private ObjectOutputStream out;
    private final long initialStartTime;
    private CollectionStatistic systemStatistic;

    public QueryRuntimeStatistics() {
        block4: {
            this.collectionStats = new Hashtable();
            this.queryCountFile = null;
            this.replacedQueryCountFile = null;
            this.out = null;
            this.initialStartTime = new Date().getTime();
            this.systemStatistic = null;
            try {
                String configDir = GlobalConfiguration.getConfiguration() == null ? null : GlobalConfiguration.getConfiguration().getConfigPath();
                this.queryCountFile = configDir == null ? new File(QueryCountFileName) : new File(configDir + File.separator + QueryCountFileName);
                this.systemStatistic = new CollectionStatistic(this.initialStartTime);
                this.initQueryCount();
            }
            catch (ExtendedException e) {
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    Loggers.logger.log(Level.SEVERE, e);
                }
            }
            catch (IOException e) {
                if (!Loggers.logger.isLoggable(Level.SEVERE)) break block4;
                Loggers.logger.log(Level.SEVERE, new ExtendedException(e));
            }
        }
    }

    private void initQueryCount() throws ExtendedException, IOException {
        if (this.queryCountFile.exists()) {
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(new FileInputStream(this.queryCountFile));
                this.todaysQueryCount = (QueryCount)in.readObject();
                in.close();
            }
            catch (Exception e) {
                this.todaysQueryCount = null;
                if (in != null) {
                    in.close();
                }
                Message msg = new Message("S0211E.QUERY_COUNT_FILE_MISSING_OR_CORRUPTED");
                throw new ExtendedException(msg, (Throwable)e);
            }
        } else {
            Message msg = new Message("S0211E.QUERY_COUNT_FILE_MISSING_OR_CORRUPTED");
            msg.addArgument(this.queryCountFile.getAbsolutePath());
            throw new ExtendedException(msg);
        }
    }

    private void persistQueryCount() throws ExtendedException {
        try {
            this.replacedQueryCountFile = new File(this.queryCountFile.getAbsolutePath() + ".replaced");
            this.out = new ObjectOutputStream(new FileOutputStream(this.replacedQueryCountFile));
            this.out.writeObject(this.todaysQueryCount);
            this.out.close();
            this.queryCountFile.delete();
            this.replacedQueryCountFile.renameTo(this.queryCountFile);
        }
        catch (FileNotFoundException e) {
            Message msg = new Message("S0212E.UNABLE_TO_WRITE_TO_QUERY_COUNT_FILE");
            throw new ExtendedException(msg, (Throwable)e);
        }
        catch (IOException e) {
            Message msg = new Message("S0212E.UNABLE_TO_WRITE_TO_QUERY_COUNT_FILE");
            throw new ExtendedException(msg, (Throwable)e);
        }
    }

    public void stop() throws ExtendedException {
        if (this.todaysQueryCount != null) {
            this.persistQueryCount();
        }
    }

    private void incrementTodaysQueryCount() {
        if (this.todaysQueryCount != null) {
            this.todaysQueryCount.incrementCount();
        }
    }

    public boolean isQueryPerDayLimitExceeded() throws ExtendedException {
        if (this.todaysQueryCount == null) {
            Message msg = new Message("S0211E.QUERY_COUNT_FILE_MISSING_OR_CORRUPTED");
            throw new ExtendedException(msg);
        }
        ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
        return this.todaysQueryCount.getCount() > releaseInfo.getQueryPerDayLimit();
    }

    public void reset() {
        if (!this.collectionStats.isEmpty()) {
            Enumeration<CollectionStatistic> enumeration = this.collectionStats.elements();
            while (enumeration.hasMoreElements()) {
                CollectionStatistic stat = enumeration.nextElement();
                stat.reset();
            }
        }
        this.systemStatistic.reset();
    }

    public long getTodaysQueryCount() throws ExtendedException {
        if (this.todaysQueryCount == null) {
            Message msg = new Message("S0211E.QUERY_COUNT_FILE_MISSING_OR_CORRUPTED");
            throw new ExtendedException(msg);
        }
        return this.todaysQueryCount.getCount();
    }

    public long getAverageQueriesResponseTime(String collectionID) {
        if (null != collectionID) {
            CollectionStatistic stat = this.collectionStats.get(collectionID);
            if (null == stat) {
                stat = new CollectionStatistic(this.initialStartTime);
                this.collectionStats.put(collectionID, stat);
            }
            return (long)stat.averageQueriesResponseTime;
        }
        return 0L;
    }

    public long getAverageQueriesResponseTime() {
        return (long)this.systemStatistic.averageQueriesResponseTime;
    }

    public long getAverageNumberQueriesPerMinute(String collectionID) {
        if (null != collectionID) {
            CollectionStatistic stat = this.collectionStats.get(collectionID);
            if (null == stat) {
                stat = new CollectionStatistic(this.initialStartTime);
                this.collectionStats.put(collectionID, stat);
            }
            return QueryRuntimeStatistics.getAverageNumberQueriesPerMinute(stat);
        }
        return 0L;
    }

    public long getAverageNumberQueriesPerMinute() {
        return QueryRuntimeStatistics.getAverageNumberQueriesPerMinute(this.systemStatistic);
    }

    private static long getAverageNumberQueriesPerMinute(CollectionStatistic stat) {
        if (0L == stat.numQueriesSeen) {
            return 0L;
        }
        double elapsedTimeMS = new Date().getTime() - stat.startTime;
        double elapsedTimeMinutes = Math.ceil(elapsedTimeMS / 1000.0 / 60.0);
        if (0.0 == elapsedTimeMinutes) {
            return stat.numQueriesSeen;
        }
        return (long)((double)stat.numQueriesSeen / elapsedTimeMinutes);
    }

    public void newQuery(LoggedQuery newLoggedQuery) {
        if (null == newLoggedQuery) {
            return;
        }
        String collectionID = newLoggedQuery.getCollectionID();
        if (null != collectionID) {
            CollectionStatistic stat = this.collectionStats.get(collectionID);
            if (null == stat) {
                stat = new CollectionStatistic(this.initialStartTime);
                this.collectionStats.put(collectionID, stat);
            }
            QueryRuntimeStatistics.updateStatisticForNewQuery(stat, newLoggedQuery.getQueryResponseTime());
        }
        QueryRuntimeStatistics.updateStatisticForNewQuery(this.systemStatistic, newLoggedQuery.getQueryResponseTime());
        this.incrementTodaysQueryCount();
    }

    private static void updateStatisticForNewQuery(CollectionStatistic stat, long newQueryResponseTime) {
        double previousTotalResponseTime = stat.averageQueriesResponseTime * (double)stat.numQueriesSeen;
        ++stat.numQueriesSeen;
        stat.averageQueriesResponseTime = (previousTotalResponseTime + (double)newQueryResponseTime) / (double)stat.numQueriesSeen;
    }

    private static final class CollectionStatistic {
        public long startTime = 0L;
        public long numQueriesSeen = 0L;
        public double averageQueriesResponseTime = 0.0;

        public CollectionStatistic(long startTime2) {
            this.startTime = startTime2;
        }

        public void reset() {
            this.startTime = new Date().getTime();
            this.numQueriesSeen = 0L;
            this.averageQueriesResponseTime = 0.0;
        }
    }
}

