/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.spell.querylog;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.httplistener.ContextType;
import com.ibm.es.nuvo.logging.ClickedResultMap;
import com.ibm.es.nuvo.logging.CompactLogRecordIterator;
import com.ibm.es.nuvo.logging.CountAndTimeStamp;
import com.ibm.es.nuvo.logging.LoggedQuery;
import com.ibm.es.nuvo.logging.QueryCountAndTimeStamp;
import com.ibm.es.nuvo.search.common.FileFetcherURI;
import com.ibm.es.nuvo.spell.querylog.BoundedFrequentWordSet;
import com.ibm.es.nuvo.spell.querylog.DictionaryWord;
import com.ibm.es.nuvo.spell.querylog.DictionaryWordComparatorByWord;
import com.ibm.es.nuvo.spell.querylog.DictionaryWordFileIterator;
import com.ibm.es.nuvo.spell.querylog.DictionaryWordTreeSet;
import com.ibm.es.nuvo.util.ExpiryMap;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.LogRecord;

public class QueryLogReport {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static int MAX_LOGS = 150000;
    private static String TMP_LOG_FILE_NAME = "TempQuery.log";
    private static long SESSION_TIMEOUT_DURATION = 30000L;
    private File tmpLogFile = null;
    private int numberOfTopTerms = 0;
    private BoundedFrequentWordSet mostFrequentQuerySet = null;
    private BoundedFrequentWordSet mostFrequentNoResultSet = null;
    private BoundedFrequentWordSet mostFrequentNoClickedResultSet = null;
    private BoundedFrequentWordSet mostFrequentResultsSet = null;
    private DictionaryWordTreeSet accumulatedWords = null;
    private TreeMap<String, ClickedResultMap> queryClickedResults = null;
    private File tempDirectory = null;
    private String cid = null;
    private ReportType currentReport;
    private boolean collectClickedResultsRecords = false;
    private boolean collectQueriesRecords = false;
    private static String apiFetchString = null;
    private int queriesProcessed = 0;
    private int queriesToProcess;
    private boolean requiredQueriesProcessed = false;
    private ExpiryMap openSessions;
    private long cutOffTimestamp = 0L;
    private boolean onlyIncludeNoResultQueries = false;
    private boolean onlyIncludeResultQueries = false;

    private QueryLogReport(int numberOfTopTerms, File tempDirectory, String cid, ReportType curRep) throws IOException, ExtendedException {
        this.currentReport = curRep;
        this.numberOfTopTerms = numberOfTopTerms;
        this.tempDirectory = tempDirectory;
        this.cid = cid;
        this.collectClickedResultsRecords = this.currentReport == ReportType.TOP_CLICKED_RESULTS || this.currentReport == ReportType.QUERIES_WITH_NO_CLICKS || this.currentReport == ReportType.TOP_QUERIES_WITH_CLICKED_RESULT;
        this.collectQueriesRecords = this.currentReport != ReportType.TOP_CLICKED_RESULTS;
        if (this.currentReport == ReportType.QUERIES_WITH_NO_RESULTS) {
            this.mostFrequentNoResultSet = new BoundedFrequentWordSet(this.numberOfTopTerms);
            this.onlyIncludeNoResultQueries = true;
        }
        if (this.currentReport == ReportType.QUERIES_WITH_NO_CLICKS) {
            this.mostFrequentNoClickedResultSet = new BoundedFrequentWordSet(this.numberOfTopTerms);
            this.onlyIncludeResultQueries = true;
        }
        if (this.currentReport == ReportType.TOP_CLICKED_RESULTS) {
            this.mostFrequentResultsSet = new BoundedFrequentWordSet(this.numberOfTopTerms);
        }
        if (this.collectQueriesRecords) {
            this.mostFrequentQuerySet = new BoundedFrequentWordSet(this.numberOfTopTerms);
            this.accumulatedWords = new DictionaryWordTreeSet(this.numberOfTopTerms, this.tempDirectory, new DictionaryWordComparatorByWord());
        }
        if (this.collectClickedResultsRecords) {
            this.queryClickedResults = new TreeMap();
        }
        ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
        this.queriesToProcess = releaseInfo.getValueAsInt("System", "QueriesToProcess", 100000);
        this.tmpLogFile = new File(this.tempDirectory + File.separator + TMP_LOG_FILE_NAME);
        this.openSessions = new ExpiryMap(SESSION_TIMEOUT_DURATION);
    }

    public static void main(String[] args) {
        if (null == args || args.length <= 1) {
            System.out.println("QueryLogReport cid inputFile");
            System.exit(1);
        }
        File[] files = new File[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            files[i - 1] = new File(args[i]);
        }
        File parent = new File(files[0].getAbsolutePath());
        parent = parent.getParentFile();
        try {
            DictionaryWord[] mfqNoResult;
            QueryLogReport report = QueryLogReport.generateReport(100, files[0].getParentFile(), files, args[0], ReportType.TOP_QUERIES);
            DictionaryWord[] mfq = report.getMostFrequentQueries();
            System.out.println("**** MOST FREQUENT ****");
            for (DictionaryWord word : mfq) {
                System.out.println(word.getWord());
            }
            System.out.println();
            System.out.println("**** MOST FREQUENT NO RESULT ****");
            for (DictionaryWord word : mfqNoResult = report.getMostFrequentQueriesWithNoResults()) {
                System.out.println(word.getWord());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExtendedException e) {
            e.printStackTrace();
        }
    }

    public DictionaryWord[] getMostFrequentQueries() {
        if (null == this.mostFrequentQuerySet) {
            return new DictionaryWord[0];
        }
        return this.mostFrequentQuerySet.getWords();
    }

    public DictionaryWord[] getMostFrequentQueriesWithNoResults() {
        if (null == this.mostFrequentNoResultSet) {
            return new DictionaryWord[0];
        }
        return this.mostFrequentNoResultSet.getWords();
    }

    public DictionaryWord[] getMostFrequentQueriesWithNoClickedResults() {
        if (null == this.mostFrequentNoClickedResultSet) {
            return new DictionaryWord[0];
        }
        return this.mostFrequentNoClickedResultSet.getWords();
    }

    public DictionaryWord[] getMostFrequentResults() {
        if (null == this.mostFrequentResultsSet) {
            return new DictionaryWord[0];
        }
        return this.mostFrequentResultsSet.getWords();
    }

    public static QueryLogReport generateReport(int numberOfTopTerms, File[] queryLogFiles, String cid, ReportType curRep) throws IOException, ExtendedException {
        File tempDirectory = new File(GlobalConfiguration.getConfiguration().getTempDirectory());
        return QueryLogReport.generateReport(numberOfTopTerms, tempDirectory, queryLogFiles, cid, curRep);
    }

    public static QueryLogReport generateReport(int numberOfTopTerms, File tempDirectory, File[] queryLogFiles, String cid, ReportType curRep) throws IOException, ExtendedException {
        QueryLogReport queryReport = new QueryLogReport(numberOfTopTerms, tempDirectory, cid, curRep);
        queryReport.analyzeQueryLog(queryLogFiles);
        if (queryReport.currentReport == ReportType.TOP_QUERIES) {
            queryReport.processTopTerms();
        }
        if (queryReport.currentReport == ReportType.QUERIES_WITH_NO_RESULTS) {
            queryReport.processTopTermsWithNoResults();
        }
        if (queryReport.currentReport == ReportType.TOP_QUERIES_WITH_CLICKED_RESULT) {
            queryReport.processTopTermsWithClickedResults();
        }
        if (queryReport.currentReport == ReportType.QUERIES_WITH_NO_CLICKS) {
            queryReport.processTopTermsWithNoClickedResults();
        }
        if (queryReport.currentReport == ReportType.TOP_CLICKED_RESULTS) {
            queryReport.processTopClickedResult();
        }
        return queryReport;
    }

    private void processTopTerms() throws IOException {
        this.accumulatedWords.mergeToDisk();
        DictionaryWordFileIterator iterator = this.accumulatedWords.getFileIterator();
        while (iterator.hasNext()) {
            DictionaryWord word = iterator.next();
            this.mostFrequentQuerySet.add(word);
        }
        this.accumulatedWords.clear();
        this.accumulatedWords.clearDisk();
    }

    private void processTopTermsWithClickedResults() throws IOException {
        this.accumulatedWords.mergeToDisk();
        DictionaryWordFileIterator iterator = this.accumulatedWords.getFileIterator();
        while (iterator.hasNext()) {
            DictionaryWord word = iterator.next();
            ClickedResultMap resultsMp = this.queryClickedResults.get(word.getWord());
            if (null != resultsMp) {
                String result = "";
                String title = "";
                int count = 0;
                int topCount = 0;
                long tstamp = 0L;
                Set allres = resultsMp.entrySet();
                for (Map.Entry oneEnt : allres) {
                    CountAndTimeStamp cntAndTs = (CountAndTimeStamp)oneEnt.getValue();
                    count += cntAndTs.count;
                    if (cntAndTs.count <= topCount && (cntAndTs.count != topCount || cntAndTs.timestamp <= tstamp)) continue;
                    result = cntAndTs.clickableUrl;
                    title = cntAndTs.title;
                    tstamp = cntAndTs.timestamp;
                    topCount = cntAndTs.count;
                }
                word.setClickedResultsCount(count);
                word.setTopClickedResult(result);
                word.setTopClickedTitle(title);
            }
            this.mostFrequentQuerySet.add(word);
        }
        this.queryClickedResults.clear();
        this.accumulatedWords.clear();
        this.accumulatedWords.clearDisk();
    }

    private void processTopTermsWithNoResults() throws IOException {
        this.accumulatedWords.mergeToDisk();
        DictionaryWordFileIterator iterator = this.accumulatedWords.getFileIterator();
        while (iterator.hasNext()) {
            DictionaryWord word = iterator.next();
            if (0 != word.getResultsCount()) continue;
            this.mostFrequentNoResultSet.add(word);
        }
        this.accumulatedWords.clear();
        this.accumulatedWords.clearDisk();
    }

    private void processTopTermsWithNoClickedResults() throws IOException {
        this.accumulatedWords.mergeToDisk();
        DictionaryWordFileIterator iterator = this.accumulatedWords.getFileIterator();
        while (iterator.hasNext()) {
            DictionaryWord word = iterator.next();
            ClickedResultMap resultsMp = this.queryClickedResults.get(word.getWord());
            if (null != resultsMp || !word.getClickedThroughOn() || word.getResultsCount() <= 0) continue;
            this.mostFrequentNoClickedResultSet.add(word);
        }
        this.queryClickedResults.clear();
        this.accumulatedWords.clear();
        this.accumulatedWords.clearDisk();
    }

    private void processTopClickedResult() {
        TreeMap<String, QueryCountAndTimeStamp> topResultsMp = new TreeMap<String, QueryCountAndTimeStamp>();
        Set<Map.Entry<String, ClickedResultMap>> allquerisWithres = this.queryClickedResults.entrySet();
        for (Map.Entry<String, ClickedResultMap> oneQEnt : allquerisWithres) {
            String oneQ = oneQEnt.getKey();
            ClickedResultMap resultsMp = oneQEnt.getValue();
            Set allres = resultsMp.entrySet();
            for (Map.Entry oneResEnt : allres) {
                String oneRes = (String)oneResEnt.getKey();
                CountAndTimeStamp cntAndTs = (CountAndTimeStamp)oneResEnt.getValue();
                QueryCountAndTimeStamp qcats = (QueryCountAndTimeStamp)topResultsMp.get(oneRes);
                if (null == qcats) {
                    qcats = new QueryCountAndTimeStamp(oneQ, cntAndTs.count, cntAndTs.timestamp, cntAndTs.title, cntAndTs.clickableUrl, cntAndTs.count);
                    topResultsMp.put(oneRes, qcats);
                    continue;
                }
                qcats.totalClickCount += cntAndTs.count;
                if (cntAndTs.count <= qcats.count && (cntAndTs.count != qcats.count || cntAndTs.timestamp <= qcats.timestamp)) continue;
                qcats.query = oneQ;
                qcats.timestamp = cntAndTs.timestamp;
            }
        }
        Set alltopResults = topResultsMp.entrySet();
        for (Map.Entry oneTREnt : alltopResults) {
            QueryCountAndTimeStamp qcats = (QueryCountAndTimeStamp)oneTREnt.getValue();
            this.mostFrequentResultsSet.add(new DictionaryWord(qcats.query, qcats.clickableUrl, qcats.title, qcats.timestamp, qcats.totalClickCount));
        }
        this.queryClickedResults.clear();
    }

    private void analyzeQueryLog(File[] queryLogFiles) throws ExtendedException {
        if (null == queryLogFiles) {
            throw new ExtendedException(new Message("G0035E.FILE_NOT_EXIST", "null"));
        }
        for (File queryLogFile : queryLogFiles) {
            this.analyzeQueryLog(queryLogFile, true);
            if (!this.requiredQueriesProcessed) continue;
            return;
        }
    }

    private void analyzeQueryLog(File queryLogFile, boolean reverse) throws ExtendedException {
        if (reverse) {
            this.reverseFile(queryLogFile);
            this.analyzeQueryLog(this.tmpLogFile);
        } else {
            this.analyzeQueryLog(queryLogFile);
        }
    }

    private void reverseFile(File queryLogFile) throws ExtendedException {
        try {
            if (this.tmpLogFile.exists()) {
                this.tmpLogFile.delete();
            }
            InputStreamReader fReader = new InputStreamReader((InputStream)new FileInputStream(queryLogFile), "UTF-8");
            BufferedReader reader = new BufferedReader(fReader);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.tmpLogFile), "UTF-8"));
            String[] lines = new String[MAX_LOGS];
            int count = 0;
            while ((lines[count++] = reader.readLine()) != null) {
            }
            reader.close();
            for (int i = count - 2; i >= 0; --i) {
                writer.write(lines[i]);
            }
            writer.close();
        }
        catch (FileNotFoundException e) {
            throw new ExtendedException(new Message("G0035E.FILE_NOT_EXIST", queryLogFile.getAbsolutePath()), (Throwable)e);
        }
        catch (IOException e) {
            throw new ExtendedException(e);
        }
    }

    private void analyzeQueryLog(File queryLogFile) throws ExtendedException {
        if (null == queryLogFile) {
            throw new ExtendedException(new Message("G0035E.FILE_NOT_EXIST", "null"));
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(queryLogFile);
            bis = new BufferedInputStream(fis, 0x1400000);
            this.analyzeQueryLog(bis);
            try {
                fis.close();
            }
            catch (IOException e) {
                throw new ExtendedException(e);
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new ExtendedException(new Message("G0035E.FILE_NOT_EXIST", queryLogFile.getAbsolutePath()), (Throwable)fnfe);
        }
    }

    private void analyzeQueryLog(InputStream is) {
        this.analyzeQueryLog(new CompactLogRecordIterator(is));
    }

    private void checkAndAddSession(String sid, long timeStamp) {
        if (!this.openSessions.containsKey(sid)) {
            this.openSessions.put(sid, timeStamp);
        }
    }

    private void setCutoff(long currentTimestamp) {
        this.cutOffTimestamp = currentTimestamp;
        this.openSessions.removeExpired(currentTimestamp);
    }

    private boolean checkExitCondition(long currentTimestamp) {
        return currentTimestamp < this.cutOffTimestamp - SESSION_TIMEOUT_DURATION;
    }

    private boolean checkAndRemoveExpiredSession(String sid, long timeStamp) {
        return this.openSessions.checkAndRemoveExpired(sid, timeStamp);
    }

    private void analyzeQueryLog(CompactLogRecordIterator iterator) {
        while (iterator.hasNext()) {
            LogRecord logRecord = iterator.next();
            if (null == logRecord) continue;
            try {
                LoggedQuery loggedQuery = new LoggedQuery(logRecord);
                if (this.collectQueriesRecords && loggedQuery.isQueryRecord()) {
                    if (this.queriesProcessed >= this.queriesToProcess) {
                        if (this.checkExitCondition(loggedQuery.getTimeStamp())) {
                            this.requiredQueriesProcessed = true;
                            return;
                        }
                        if (!this.checkAndRemoveExpiredSession(loggedQuery.getSessionId(), loggedQuery.getTimeStamp())) continue;
                    }
                    if (this.onlyIncludeNoResultQueries && loggedQuery.getResultsCount() != 0 || this.onlyIncludeResultQueries && loggedQuery.getResultsCount() == 0) continue;
                    if (loggedQuery.getCollectionID().equals(this.cid)) {
                        DictionaryWord word = new DictionaryWord(loggedQuery);
                        this.accumulatedWords.put(word);
                    }
                    ++this.queriesProcessed;
                    if (this.queriesProcessed <= this.queriesToProcess) {
                        this.checkAndAddSession(loggedQuery.getSessionId(), loggedQuery.getTimeStamp());
                    }
                    if (this.queriesProcessed == this.queriesToProcess) {
                        this.setCutoff(loggedQuery.getTimeStamp());
                    }
                }
                if (!this.collectClickedResultsRecords || !loggedQuery.isClickedResultRecord()) continue;
                if (this.queriesProcessed >= this.queriesToProcess) {
                    if (this.checkExitCondition(loggedQuery.getTimeStamp())) {
                        this.requiredQueriesProcessed = true;
                        return;
                    }
                    if (!this.checkAndRemoveExpiredSession(loggedQuery.getSessionId(), loggedQuery.getTimeStamp())) continue;
                }
                if (loggedQuery.getCollectionID().equals(this.cid)) {
                    CountAndTimeStamp cntAndTs;
                    String wordIn;
                    ClickedResultMap resultsMp;
                    String baseUrl = QueryLogReport.parseBaseUrl(loggedQuery.getClickedResult());
                    String clickableUrl = QueryLogReport.getClickableUrl(loggedQuery.getClickedResult(), baseUrl, this.cid, loggedQuery.getCharset(), loggedQuery.getMimeType(), loggedQuery.getSpaceId());
                    String title = loggedQuery.getResultTitle();
                    if (null == title || 0 == title.length()) {
                        title = baseUrl;
                    }
                    if (null == (resultsMp = this.queryClickedResults.get(wordIn = DictionaryWord.normalizeQueryWords(loggedQuery.getQueryText())))) {
                        resultsMp = new ClickedResultMap();
                        cntAndTs = new CountAndTimeStamp(1, loggedQuery.getTimeStamp(), title, clickableUrl);
                        resultsMp.put(baseUrl, cntAndTs);
                        this.queryClickedResults.put(wordIn, resultsMp);
                    } else {
                        cntAndTs = (CountAndTimeStamp)resultsMp.get(baseUrl);
                        if (null == cntAndTs) {
                            cntAndTs = new CountAndTimeStamp(1, loggedQuery.getTimeStamp(), title, clickableUrl);
                            resultsMp.put(baseUrl, cntAndTs);
                        } else {
                            ++cntAndTs.count;
                            if (cntAndTs.timestamp < loggedQuery.getTimeStamp()) {
                                cntAndTs.timestamp = loggedQuery.getTimeStamp();
                            }
                        }
                    }
                }
                if (this.currentReport != ReportType.TOP_CLICKED_RESULTS) continue;
                ++this.queriesProcessed;
                if (this.queriesProcessed <= this.queriesToProcess) {
                    this.checkAndAddSession(loggedQuery.getSessionId(), loggedQuery.getTimeStamp());
                }
                if (this.queriesProcessed != this.queriesToProcess) continue;
                this.setCutoff(loggedQuery.getTimeStamp());
            }
            catch (Exception exception) {}
        }
    }

    public static String parseBaseUrl(String orgUrl) {
        if (!orgUrl.startsWith("/")) {
            return orgUrl;
        }
        try {
            String tmpUrl = "http://localhost" + orgUrl;
            URL aURL = new URL(tmpUrl);
            String q = aURL.getQuery();
            if (q.length() == 0) {
                return orgUrl;
            }
            StringTokenizer vST = new StringTokenizer(q, "&=");
            String queryStr = "";
            while (vST.hasMoreTokens()) {
                String parameterName = vST.nextToken();
                if (parameterName.equalsIgnoreCase("query")) {
                    queryStr = vST.nextToken();
                    if (!queryStr.startsWith("cache::")) break;
                    queryStr = queryStr.substring(7);
                    break;
                }
                if (!parameterName.equalsIgnoreCase("url")) continue;
                queryStr = vST.nextToken();
                break;
            }
            return URLDecoder.decode(queryStr, "UTF-8");
        }
        catch (Exception exception) {
            return orgUrl;
        }
    }

    public static String getClickableUrl(String orgUrl, String baseUrl, String collectionId, String charset, String mimeType, String spaceId) {
        if (null == apiFetchString) {
            apiFetchString = ContextType.Search.getContextPath() + "/fetch?";
        }
        if (!orgUrl.startsWith("/")) {
            return orgUrl;
        }
        if (orgUrl.startsWith(apiFetchString)) {
            return orgUrl;
        }
        if (!baseUrl.startsWith("http")) {
            String newUrl = FileFetcherURI.constructFetchableURI(baseUrl, collectionId, mimeType, charset, spaceId, null);
            return newUrl;
        }
        return baseUrl;
    }

    public int getQueriesProcessed() {
        return this.queriesProcessed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReportType {
        TOP_QUERIES,
        TOP_QUERIES_WITH_CLICKED_RESULT,
        QUERIES_WITH_NO_RESULTS,
        QUERIES_WITH_NO_CLICKS,
        TOP_CLICKED_RESULTS;

    }
}

