/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.spell.querylog;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.logging.LoggedQuery;
import com.ibm.es.nuvo.spell.querylog.QueryRuntimeStatistics;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class QueryLogListener
extends Handler {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private int countToNotify = 1000;
    private int curCount = 0;
    private Object objectToNotify = null;
    private QueryRuntimeStatistics instance = GlobalSystem.getSingleInstance().getQueryRuntimeStatistics();

    public QueryLogListener() {
    }

    public QueryLogListener(Object objectToNotify) {
        this(objectToNotify, 1000);
    }

    public QueryLogListener(Object objectToNotify, int countToNotify) {
        this();
        if (countToNotify > 0) {
            this.countToNotify = countToNotify;
        }
        this.objectToNotify = objectToNotify;
        this.initNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initNotify() {
        Object object = this.objectToNotify;
        synchronized (object) {
            this.objectToNotify.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord record) {
        if (null != this.objectToNotify) {
            ++this.curCount;
            if (0 == this.curCount % this.countToNotify) {
                this.curCount = 0;
                Object object = this.objectToNotify;
                synchronized (object) {
                    this.objectToNotify.notify();
                }
            }
        }
        try {
            this.instance.newQuery(new LoggedQuery(record));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }
}

