/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.spell.querylog;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.SettingsConfigurationManager;
import com.ibm.es.nuvo.configuration.SystemSettings;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.spell.DictionaryFileNameFilter;
import com.ibm.es.nuvo.spell.SpellChecker;
import com.ibm.es.nuvo.spell.querylog.DictionaryBuilder;
import com.ibm.es.nuvo.util.threadpool.Task;
import java.io.File;
import java.util.logging.Level;

public class QueryLogDictionaryBuildTask
extends Task {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private long lastModifiedTimestamp = 0L;
    private DictionaryBuilder builder = null;
    private Boolean isRunning = Boolean.TRUE;
    private Object waitNotifier = new Object();

    public QueryLogDictionaryBuildTask() throws ExtendedException {
        File spellUpdatedDicDir;
        SettingsConfigurationManager settingsConfigMgr = SettingsConfigurationManager.getConfigurationManager();
        SystemSettings systemSettings = (SystemSettings)settingsConfigMgr.getSettings(SettingsConfigurationManager.SettingsType.SystemSettings);
        Long lastMod = systemSettings.getLastQueryLogDictionaryBuildTimeStamp();
        if (null != lastMod) {
            this.lastModifiedTimestamp = lastMod;
        }
        if (!(spellUpdatedDicDir = SpellChecker.getSpellQLUpdatedPath()).isDirectory()) {
            spellUpdatedDicDir.mkdirs();
        }
        this.builder = new DictionaryBuilder("QL", spellUpdatedDicDir);
        Loggers.getWrappedQueryLogger().setLogRotationNotifier(this.waitNotifier);
    }

    private File getQueryLog() {
        File[] logFiles = Loggers.getWrappedQueryLogger().getLogFiles();
        if (null != logFiles) {
            for (int i = 0; i < logFiles.length; ++i) {
                File curLogFile = logFiles[i];
                if (!curLogFile.getName().endsWith(".1.log")) continue;
                return curLogFile;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask() {
        while (true) {
            Boolean bl = this.isRunning;
            synchronized (bl) {
                if (!this.isRunning.booleanValue()) {
                    return;
                }
            }
            try {
                block18: {
                    File secondRotatedLog = this.getQueryLog();
                    if (null != secondRotatedLog) {
                        boolean isBelowHalfLimit;
                        int lastIndex = secondRotatedLog.getName().length() - ".1.log".length();
                        String firstLogName = secondRotatedLog.getName().substring(0, lastIndex) + ".0.log";
                        File firstRotatedLog = new File(secondRotatedLog.getParent(), firstLogName);
                        long fileLimit = Loggers.getWrappedQueryLogger().getLimit();
                        long firstRotatedLogSize = 0L;
                        if (firstRotatedLog.exists()) {
                            firstRotatedLogSize = firstRotatedLog.length();
                        }
                        boolean bl2 = isBelowHalfLimit = firstRotatedLogSize < fileLimit / 2L;
                        if (isBelowHalfLimit && secondRotatedLog.lastModified() > this.lastModifiedTimestamp) {
                            this.lastModifiedTimestamp = secondRotatedLog.lastModified();
                            SettingsConfigurationManager settingsConfigMgr = SettingsConfigurationManager.getConfigurationManager();
                            SystemSettings systemSettings = (SystemSettings)settingsConfigMgr.getSettingsForUpdate(SettingsConfigurationManager.SettingsType.SystemSettings);
                            systemSettings.setLastQueryLogDictionaryBuildTimeStamp(this.lastModifiedTimestamp);
                            try {
                                settingsConfigMgr.updateStateObject(SettingsConfigurationManager.SettingsType.SystemSettings, systemSettings);
                                this.builder.createDictionariesFromQueryLog(Loggers.getWrappedQueryLogger().getLogFiles());
                                File spellUpdateDir = this.builder.getDictionariesStoreDirectory();
                                File spellDir = spellUpdateDir.getParentFile();
                                DictionaryFileNameFilter filter = new DictionaryFileNameFilter("QL", null);
                                File[] updatedDicFiles = spellUpdateDir.listFiles(filter);
                                if (null != updatedDicFiles && updatedDicFiles.length > 0) {
                                    for (int i = 0; i < updatedDicFiles.length; ++i) {
                                        File mainDicFile = new File(spellDir, updatedDicFiles[i].getName());
                                        if (mainDicFile.isFile()) continue;
                                        updatedDicFiles[i].renameTo(mainDicFile);
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (!Loggers.logger.isLoggable(Level.WARNING)) break block18;
                                ExtendedException ee = new ExtendedException(new Message("S0017W.QUERYLOG_DICTIONARY_CREATION_FAILED", secondRotatedLog.getAbsolutePath()), (Throwable)e);
                                Loggers.logger.log(Level.WARNING, ee);
                            }
                        }
                    }
                }
                Object object = this.waitNotifier;
                synchronized (object) {
                    if (this.isRunning.booleanValue()) {
                        this.waitNotifier.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                this.shutdownTask();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownTask() {
        Boolean bl = this.isRunning;
        synchronized (bl) {
            this.isRunning = Boolean.FALSE;
        }
    }

    public Object getEvent() {
        return null;
    }
}

