/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.spell.querylog;

import com.ibm.es.nuvo.spell.querylog.DictionaryWord;
import com.ibm.es.nuvo.spell.querylog.DictionaryWordComparatorByNatural;
import com.ibm.es.nuvo.spell.querylog.DictionaryWordFileIterator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryWordTreeSet
extends TreeMap<DictionaryWord, DictionaryWord> {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = 4855710512934503619L;
    private int maxSize = 0;
    private File onDiskDataFile = null;
    private Comparator<? super DictionaryWord> comparatorToUse = null;

    public DictionaryWordTreeSet(int maxSize) {
        if (maxSize > 0) {
            this.maxSize = maxSize;
        }
        this.initComparator();
    }

    public DictionaryWordTreeSet(int maxSize, File tempDirectory) throws IOException {
        if (maxSize > 0) {
            this.maxSize = maxSize;
        }
        this.onDiskDataFile = File.createTempFile("DicWordTreeSet", ".dat", tempDirectory);
        this.initComparator();
    }

    public DictionaryWordTreeSet(int maxSize, File tempDirectory, Comparator<DictionaryWord> comparator) throws IOException {
        super(comparator);
        if (maxSize > 0) {
            this.maxSize = maxSize;
        }
        this.onDiskDataFile = File.createTempFile("DicWordTreeSet", ".dat", tempDirectory);
        this.initComparator();
    }

    private void initComparator() {
        this.comparatorToUse = this.comparator();
        if (null == this.comparatorToUse) {
            this.comparatorToUse = new DictionaryWordComparatorByNatural();
        }
    }

    @Override
    public DictionaryWord put(DictionaryWord key, DictionaryWord value) {
        if (null == key || null == value) {
            return null;
        }
        DictionaryWord insertedValue = (DictionaryWord)this.get(key);
        if (null == insertedValue) {
            if (this.maxSize > 0 && this.size() == this.maxSize) {
                try {
                    this.mergeToDisk();
                }
                catch (IOException e) {
                    return null;
                }
            }
            if (this.maxSize == 0 || this.size() < this.maxSize) {
                DictionaryWord valueCopy = new DictionaryWord(value);
                insertedValue = super.put(key, valueCopy);
            }
        } else if (insertedValue.getDate() < value.getDate()) {
            value.incrementFrequency(insertedValue.getFrequency());
            if (insertedValue.getClickedThroughOn()) {
                value.setClickedThroughOn(true);
            }
            DictionaryWord valueCopy = new DictionaryWord(value);
            insertedValue = super.put(key, valueCopy);
        } else {
            insertedValue.incrementFrequency(value.getFrequency());
        }
        return insertedValue;
    }

    public DictionaryWord put(DictionaryWord keyValue) {
        if (null == keyValue) {
            return null;
        }
        return this.put(keyValue, keyValue);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void clearDisk() {
        if (null != this.onDiskDataFile && this.onDiskDataFile.isFile()) {
            this.onDiskDataFile.delete();
        }
    }

    public void mergeToDisk() throws IOException {
        if (null != this.onDiskDataFile && this.size() > 0) {
            this.mergeToDisk(this.comparatorToUse);
        }
    }

    private void mergeToDisk(Comparator<? super DictionaryWord> comparator) throws IOException {
        if (!this.onDiskDataFile.isFile()) {
            this.onDiskDataFile.createNewFile();
        }
        FileInputStream fis = new FileInputStream(this.onDiskDataFile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        DataInputStream dis = new DataInputStream(bis);
        File mergedFile = new File(this.onDiskDataFile.getAbsolutePath() + ".merged");
        if (mergedFile.isFile()) {
            mergedFile.delete();
        }
        FileOutputStream fos = new FileOutputStream(mergedFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        DataOutputStream dos = new DataOutputStream(bos);
        Collection values = this.values();
        Iterator iterator = values.iterator();
        DictionaryWord iterWord = null;
        DictionaryWord disWord = null;
        boolean endDIS = false;
        boolean keepGoing = true;
        while (keepGoing) {
            if (null == iterWord && iterator.hasNext()) {
                iterWord = (DictionaryWord)iterator.next();
            }
            if (null == disWord && !endDIS) {
                try {
                    String serializedString = dis.readUTF();
                    disWord = new DictionaryWord(serializedString);
                }
                catch (EOFException eof) {
                    endDIS = true;
                    disWord = null;
                }
            }
            if (null != iterWord) {
                if (null == disWord) {
                    dos.writeUTF(iterWord.toSimpleSerialize());
                    iterWord = null;
                    continue;
                }
                int compared = comparator.compare(iterWord, disWord);
                if (compared < 0) {
                    dos.writeUTF(iterWord.toSimpleSerialize());
                    iterWord = null;
                    continue;
                }
                if (0 == compared) {
                    if (disWord.getDate() >= iterWord.getDate()) {
                        disWord.incrementFrequency(iterWord.getFrequency());
                        iterWord = null;
                        continue;
                    }
                    iterWord.incrementFrequency(disWord.getFrequency());
                    disWord = null;
                    continue;
                }
                dos.writeUTF(disWord.toSimpleSerialize());
                disWord = null;
                continue;
            }
            if (null != disWord) {
                dos.writeUTF(disWord.toSimpleSerialize());
                disWord = null;
            }
            while (!endDIS) {
                try {
                    dos.writeUTF(dis.readUTF());
                }
                catch (EOFException eof) {
                    endDIS = true;
                }
            }
            keepGoing = false;
        }
        dis.close();
        dos.close();
        this.onDiskDataFile.delete();
        mergedFile.renameTo(this.onDiskDataFile);
        this.clear();
    }

    public DictionaryWordFileIterator getFileIterator() {
        if (null == this.onDiskDataFile) {
            return null;
        }
        try {
            return new DictionaryWordFileIterator(this.onDiskDataFile);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

