/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.spell.querylog;

import com.ibm.es.nuvo.spell.querylog.DictionaryWord;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryWordFileIterator
implements Iterator<DictionaryWord> {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private DataInputStream dis = null;
    private DictionaryWord nextWord = null;

    DictionaryWordFileIterator(File dictionaryWordFile) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(dictionaryWordFile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        this.dis = new DataInputStream(bis);
    }

    @Override
    public boolean hasNext() {
        if (null != this.nextWord) {
            return true;
        }
        if (null != this.dis) {
            try {
                String serializedString = this.dis.readUTF();
                this.nextWord = new DictionaryWord(serializedString);
            }
            catch (EOFException eof) {
                this.nextWord = null;
                try {
                    this.dis.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.dis = null;
            }
            catch (IOException e) {
                this.nextWord = null;
                try {
                    this.dis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.dis = null;
            }
        }
        return null != this.nextWord;
    }

    @Override
    public DictionaryWord next() {
        DictionaryWord retWord = this.nextWord;
        this.nextWord = null;
        return retWord;
    }

    @Override
    public void remove() {
    }
}

