/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.spell.querylog;

import com.ibm.es.nuvo.common.InvalidArgumentException;
import com.ibm.es.nuvo.logging.LoggedQuery;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.logging.LogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryWord
implements Comparable<DictionaryWord> {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final char FieldSeparatorChar = '\n';
    private long date = 0L;
    private int resultsCount = 0;
    private int frequency = 1;
    private String word = null;
    private Locale locale = null;
    private String localeToString = null;
    private String topClickedResult = "";
    private String topClickedTitle = "";
    private int clickedResultsCount = 0;
    private boolean clickedThroughOn = false;
    private long duration = 0L;
    private String sessionId = null;
    private String userAction = null;
    private int hashCode = 0;

    public DictionaryWord(String simpleSerialized) {
        this.fromSimpleSerialize(simpleSerialized);
    }

    public DictionaryWord(DictionaryWord toCopy) {
        this.date = toCopy.date;
        this.resultsCount = toCopy.resultsCount;
        this.frequency = toCopy.frequency;
        this.word = toCopy.word;
        this.locale = toCopy.locale;
        this.localeToString = toCopy.localeToString;
        this.hashCode = toCopy.hashCode;
        this.topClickedResult = toCopy.topClickedResult;
        this.topClickedTitle = toCopy.topClickedTitle;
        this.clickedResultsCount = toCopy.clickedResultsCount;
        this.clickedThroughOn = toCopy.clickedThroughOn;
        this.duration = toCopy.duration;
        this.sessionId = toCopy.sessionId;
        this.userAction = toCopy.userAction;
    }

    public DictionaryWord(String word, long date, Locale locale, int resultsCount) {
        this.init(word, date, locale, resultsCount);
    }

    public DictionaryWord(String word, String Result2, String Title, long date, int freq) {
        this.init(word, date, null, 0);
        this.topClickedResult = Result2;
        this.topClickedTitle = Title;
        this.frequency = freq;
    }

    public DictionaryWord(String sessionId, long start, long duration, String queryText) {
        this.init(queryText, start, null, 1);
        this.sessionId = sessionId;
        this.duration = duration;
    }

    public DictionaryWord(long date, String userAction, String queryText, String topClickedTitle, String topClickedResult) {
        this.init(queryText, date, null, 1);
        this.userAction = userAction;
        this.topClickedTitle = topClickedTitle;
        this.topClickedResult = topClickedResult;
    }

    public DictionaryWord(LogRecord logRecord) throws InvalidArgumentException {
        this(new LoggedQuery(logRecord));
    }

    public DictionaryWord(LogRecord logRecord, boolean lowerCaseQuery) throws InvalidArgumentException {
        this(new LoggedQuery(logRecord), lowerCaseQuery);
    }

    public DictionaryWord(LoggedQuery loggedQuery) {
        this(loggedQuery, false);
    }

    public DictionaryWord(LoggedQuery loggedQuery, boolean lowerCaseQuery) {
        int resultsCountIn = loggedQuery.getResultsCount();
        long dateIn = loggedQuery.getTimeStamp();
        String queryStr = loggedQuery.getQueryText();
        String localeStr = loggedQuery.getLocaleString();
        Locale localeToUse = null;
        localeToUse = localeStr.length() < 2 ? Locale.US : (localeStr.length() < 5 ? new Locale(localeStr.substring(0, 2), "XX") : new Locale(localeStr.substring(0, 2), localeStr.substring(3, 5)));
        if (lowerCaseQuery) {
            queryStr = queryStr.toLowerCase(localeToUse);
        }
        this.init(queryStr, dateIn, localeToUse, resultsCountIn);
        this.clickedThroughOn = loggedQuery.getClickThroughTracking().equals("1");
    }

    public static String normalizeQueryWords(String wordIn) {
        if (null == wordIn) {
            wordIn = "";
        }
        wordIn = wordIn.trim();
        wordIn = wordIn.replaceAll(Character.toString('\n'), " ");
        return wordIn;
    }

    private void init(String wordIn, long dateIn, Locale localeIn, int resultsCountIn) {
        if (null == localeIn) {
            localeIn = Locale.getDefault();
        }
        this.date = dateIn;
        this.resultsCount = resultsCountIn;
        this.word = DictionaryWord.normalizeQueryWords(wordIn);
        this.locale = localeIn;
        this.localeToString = this.locale.toString();
        this.hashCode = (this.localeToString + this.word).hashCode();
    }

    public long getDate() {
        return this.date;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getWord() {
        return this.word;
    }

    public void setWord(String wrd) {
        this.word = wrd;
    }

    public CharacterIterator getWordAsCharacterIterator() {
        return new StringCharacterIterator(this.getWord());
    }

    public int getWordLength() {
        return this.getWord().length();
    }

    public int getResultsCount() {
        return this.resultsCount;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public void incrementFrequency(int amountToIncrement) {
        this.frequency += amountToIncrement;
    }

    public int getClickedResultsCount() {
        return this.clickedResultsCount;
    }

    public void setClickedResultsCount(int count) {
        this.clickedResultsCount = count;
    }

    public String getTopClickedResult() {
        return this.topClickedResult;
    }

    public void setTopClickedResult(String result) {
        this.topClickedResult = result;
    }

    public String getTopClickedTitle() {
        return this.topClickedTitle;
    }

    public void setTopClickedTitle(String Title) {
        this.topClickedTitle = Title;
    }

    public boolean getClickedThroughOn() {
        return this.clickedThroughOn;
    }

    public void setClickedThroughOn(boolean flag) {
        this.clickedThroughOn = flag;
    }

    public String toSimpleSerialize() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.locale.getLanguage());
        builder.append('\n');
        builder.append(this.locale.getCountry());
        builder.append('\n');
        builder.append(this.word);
        builder.append('\n');
        builder.append(this.date);
        builder.append('\n');
        builder.append(this.resultsCount);
        builder.append('\n');
        builder.append(this.frequency);
        builder.append('\n');
        builder.append(this.clickedThroughOn);
        return builder.toString();
    }

    private void fromSimpleSerialize(String serializedString) {
        String[] fields = serializedString.split(Character.toString('\n'));
        if (fields.length != 7) {
            throw new IllegalArgumentException(serializedString);
        }
        this.init(fields[2], Long.parseLong(fields[3]), new Locale(fields[0], fields[1]), Integer.parseInt(fields[4]));
        this.frequency = Integer.parseInt(fields[5]);
        this.clickedThroughOn = Boolean.parseBoolean(fields[6]);
    }

    @Override
    public int compareTo(DictionaryWord o) {
        int compared = this.localeToString.compareTo(o.localeToString);
        if (0 == compared) {
            compared = this.word.compareToIgnoreCase(o.word);
        }
        return compared;
    }

    public boolean equals(Object o) {
        if (null == o || !(o instanceof DictionaryWord)) {
            return false;
        }
        DictionaryWord dicWord = (DictionaryWord)o;
        if (dicWord == this) {
            return true;
        }
        return 0 == this.compareTo(dicWord);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getUserAction() {
        return this.userAction;
    }

    public void setUserAction(String userAction) {
        this.userAction = userAction;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }
}

