/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.spell.querylog;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.DictionaryInfo;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.logging.CompactLogRecordIterator;
import com.ibm.es.nuvo.spell.DictionaryFileLock;
import com.ibm.es.nuvo.spell.SpellChecker;
import com.ibm.es.nuvo.spell.querylog.DictionaryWord;
import com.ibm.es.nuvo.spell.querylog.DictionaryWordFileIterator;
import com.ibm.es.nuvo.spell.querylog.DictionaryWordTreeSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.logging.LogRecord;

public class DictionaryBuilder {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final int DEFAULT_MAX_ENTRIES_PER_DIC = 100000;
    private int maxEntriesPerDictionary = 100000;
    private File directory = null;
    private String dictionaryFilePrefix = null;

    public DictionaryBuilder(String dicFilePrefix, File directoryToStoreDictionaries) throws ExtendedException {
        this(dicFilePrefix, 100000, directoryToStoreDictionaries);
    }

    public DictionaryBuilder(String dicFilePrefix, int maxEntriesPerDictionary, File directoryToStoreDictionaries) throws ExtendedException {
        if (maxEntriesPerDictionary <= 0) {
            maxEntriesPerDictionary = 100000;
        }
        this.maxEntriesPerDictionary = maxEntriesPerDictionary;
        if (null == directoryToStoreDictionaries || !directoryToStoreDictionaries.isDirectory() && !directoryToStoreDictionaries.mkdirs()) {
            throw new ExtendedException(new Message("G0009E.ARGUMENT_INVALID_VALUE", "directoryToStoreDictionaries", directoryToStoreDictionaries));
        }
        this.dictionaryFilePrefix = dicFilePrefix.trim();
        this.directory = directoryToStoreDictionaries;
    }

    public int getMaxEntriesPerDictionary() {
        return this.maxEntriesPerDictionary;
    }

    public File getDictionariesStoreDirectory() {
        return this.directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDictionariesFromQueryLog(File queryLogFile) throws ExtendedException, IOException {
        if (null == queryLogFile) {
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(queryLogFile);
        }
        catch (FileNotFoundException fnfe) {
            throw new ExtendedException(new Message("S0015E.QL_DICTIONARY_CREATION_FAILED_INVALID_LOG_FILE", queryLogFile.getAbsolutePath()), (Throwable)fnfe);
        }
        DictionaryWordTreeSet wordSet = new DictionaryWordTreeSet(this.maxEntriesPerDictionary, this.directory);
        try {
            this.accumulateWordsFromQueryLog(fis, wordSet);
            fis.close();
            fis = null;
            wordSet.mergeToDisk();
            this.createDictionariesFromWordIterator(wordSet.getFileIterator());
        }
        finally {
            if (null != wordSet) {
                wordSet.clear();
                wordSet.clearDisk();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDictionariesFromQueryLog(File[] queryLogFiles) throws ExtendedException, IOException {
        if (null == queryLogFiles) {
            throw new ExtendedException(new Message("S0015E.QL_DICTIONARY_CREATION_FAILED_INVALID_LOG_FILE", "{null}"));
        }
        DictionaryWordTreeSet wordSet = new DictionaryWordTreeSet(this.maxEntriesPerDictionary, this.directory);
        for (File queryLogFile : queryLogFiles) {
            if (null == queryLogFile) continue;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(queryLogFile);
                this.accumulateWordsFromQueryLog(fis, wordSet);
                fis.close();
                fis = null;
            }
            catch (FileNotFoundException fnfe) {
                throw new ExtendedException(new Message("S0015E.QL_DICTIONARY_CREATION_FAILED_INVALID_LOG_FILE", queryLogFile.getAbsolutePath()), (Throwable)fnfe);
            }
        }
        try {
            wordSet.mergeToDisk();
            this.createDictionariesFromWordIterator(wordSet.getFileIterator());
        }
        finally {
            if (null != wordSet) {
                wordSet.clear();
                wordSet.clearDisk();
            }
        }
    }

    private void accumulateWordsFromQueryLog(InputStream is, DictionaryWordTreeSet wordSet) {
        this.accumulateWordsFromQueryLog(new CompactLogRecordIterator(is), wordSet);
    }

    private void accumulateWordsFromQueryLog(CompactLogRecordIterator iterator, DictionaryWordTreeSet wordSet) {
        while (iterator.hasNext()) {
            LogRecord record = iterator.next();
            if (null == record) continue;
            try {
                DictionaryWord dictWord = new DictionaryWord(record, true);
                int resultsCount = dictWord.getResultsCount();
                if (resultsCount <= 0 || SpellChecker.containsMetaNonSpaceNonControlChar(dictWord.getWord())) continue;
                wordSet.put(dictWord, dictWord);
            }
            catch (Exception e) {}
        }
    }

    private void createDictionariesFromWordIterator(DictionaryWordFileIterator wordIterator) throws ExtendedException {
        Locale curLocale = null;
        Locale newLocale = null;
        Dictionary curDictionary = null;
        while (wordIterator.hasNext()) {
            DictionaryWord curWord = wordIterator.next();
            if (null == curWord) continue;
            newLocale = curWord.getLocale();
            if (null == curLocale) {
                curDictionary = this.createEmptyDictionary();
            } else if (!newLocale.equals(curLocale)) {
                this.saveDictionaryToDisk(curDictionary, curLocale);
                curDictionary = this.createEmptyDictionary();
            }
            curLocale = newLocale;
            try {
                this.addWordToDictionary(curDictionary, curWord);
            }
            catch (DLTException dlte) {}
        }
        if (curDictionary != null && curLocale != null) {
            this.saveDictionaryToDisk(curDictionary, curLocale);
        }
    }

    private Dictionary createEmptyDictionary() throws ExtendedException {
        Dictionary retDictionary = null;
        try {
            retDictionary = Dictionary.createDictionary((DictionaryInfo)new DictionaryInfo());
            retDictionary.registerType(15, "querylog featureset");
            retDictionary.registerType(1, "querylog morph");
            retDictionary.registerType(18, "querylog results count");
        }
        catch (DLTException dlte) {
            throw new ExtendedException(new Message("S0016E.EMPTY_DICTIONARY_CREATION_FAILED"), (Throwable)dlte);
        }
        return retDictionary;
    }

    private void addWordToDictionary(Dictionary dict, DictionaryWord word) throws DLTException {
        FeatureSetGloss gloss1 = new FeatureSetGloss(0, 1, false, false, true, true);
        gloss1 = dict.addGloss(15, (Gloss)gloss1);
        dict.addWord(word.getWordAsCharacterIterator(), word.getWordLength(), (Gloss)gloss1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDictionaryToDisk(Dictionary dict, Locale dictLocale) throws ExtendedException {
        long numEntries = 0L;
        try {
            numEntries = dict.getNumberOfEntries();
        }
        catch (DLTException dlte) {
            // empty catch block
        }
        if (numEntries > 0L) {
            StringBuilder prevDicFileName = new StringBuilder(this.dictionaryFilePrefix);
            prevDicFileName.append('-');
            prevDicFileName.append(dictLocale.getLanguage());
            if (dictLocale.getCountry().length() > 0) {
                prevDicFileName.append('-');
                prevDicFileName.append(dictLocale.getCountry());
            }
            prevDicFileName.append(".dic");
            File prevDictionaryFile = new File(this.directory, prevDicFileName.toString());
            try {
                dict.contract();
                try {
                    DictionaryFileLock.getInstance().acquireLock(prevDictionaryFile);
                    if (prevDictionaryFile.isFile()) {
                        prevDictionaryFile.delete();
                    }
                    dict.save(prevDictionaryFile);
                }
                finally {
                    DictionaryFileLock.getInstance().releaseLock(prevDictionaryFile);
                }
            }
            catch (Exception e) {
                throw new ExtendedException(new Message("S0014E.QL_DICTIONARY_SAVE_FAILED", null == prevDictionaryFile ? "" : prevDictionaryFile.getAbsolutePath()), (Throwable)e);
            }
        }
    }
}

