/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.spell.querylog;

import com.ibm.es.nuvo.spell.querylog.DictionaryWord;
import com.ibm.es.nuvo.spell.querylog.DictionaryWordComparatorByFrequency;
import java.util.Comparator;
import java.util.TreeSet;

public class BoundedFrequentWordSet {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected int maxNumberOfEntries = 0;
    protected TreeSet<DictionaryWord> set = null;

    public BoundedFrequentWordSet() {
    }

    public BoundedFrequentWordSet(int maxNumberOfEntries) {
        if (maxNumberOfEntries <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxNumberOfEntries = maxNumberOfEntries;
        this.set = new TreeSet<DictionaryWord>(new DictionaryWordComparatorByFrequency());
    }

    public void clear() {
        this.set.clear();
    }

    public boolean add(DictionaryWord word) {
        if (this.set.size() < this.maxNumberOfEntries) {
            return this.set.add(word);
        }
        DictionaryWord firstWord = this.set.first();
        Comparator<DictionaryWord> comparator = this.set.comparator();
        int compared = comparator.compare(word, firstWord);
        if (compared <= 0) {
            return false;
        }
        this.set.remove(firstWord);
        return this.set.add(word);
    }

    public DictionaryWord[] getWords() {
        DictionaryWord[] words = new DictionaryWord[this.set.size()];
        return this.set.toArray(words);
    }
}

