/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.spell.index;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.DictionaryInfo;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.spell.DictionaryFileLock;
import com.ibm.es.nuvo.spell.SpellChecker;
import java.io.File;
import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Locale;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;

public class DictionaryBuilder {
    private IndexReader indexReader = null;
    private File outputDir = null;
    private String outputPrefix = null;
    private static final Locale[] SupportedLocales = new Locale[]{Locale.US};

    public static void build(File textIndexDir, File outputDir, String outputPrefix) throws ExtendedException {
        DictionaryBuilder dicBuilder = new DictionaryBuilder(textIndexDir, outputDir, outputPrefix);
        dicBuilder.buildDictionaries();
    }

    private DictionaryBuilder(File textIndexDir, File outputDir, String outputPrefix) throws ExtendedException {
        try {
            this.indexReader = IndexReader.open((File)textIndexDir);
        }
        catch (Exception e) {
            throw new ExtendedException(e);
        }
        if (!outputDir.isDirectory() && !outputDir.mkdirs()) {
            throw new ExtendedException("failed to create dir");
        }
        this.outputDir = outputDir;
        this.outputPrefix = outputPrefix;
    }

    private void buildDictionaries() throws ExtendedException {
        try {
            for (Locale locale : SupportedLocales) {
                Dictionary dictionary = this.createEmptyDictionary();
                TermEnum termEnum = this.indexReader.terms();
                while (termEnum.next()) {
                    char firstChar;
                    char lastChar;
                    Term currentTerm = termEnum.term();
                    String word = currentTerm.text();
                    if (word.length() < 3 || (lastChar = word.charAt(word.length() - 1)) == '\u0001' || locale.getLanguage() == "en" && ((firstChar = word.charAt(0)) < 'a' || firstChar > 'z' || lastChar < 'a' || lastChar > 'z') || !currentTerm.field().equals("_plain") || SpellChecker.containsMetaNonSpaceNonControlChar(word) || !this.isTermInDocWithLocale(currentTerm, locale)) continue;
                    this.addTermToDictionary(dictionary, currentTerm);
                }
                this.saveDictionaryToDisk(dictionary, locale);
            }
        }
        catch (Exception e) {
            throw new ExtendedException(e);
        }
    }

    private boolean isTermInDocWithLocale(Term term, Locale locale) {
        try {
            TermDocs termDocs = this.indexReader.termDocs(term);
            while (termDocs.next()) {
                Document doc;
                String[] languages;
                int docNum = termDocs.doc();
                if (this.indexReader.isDeleted(docNum) || null == (languages = (doc = this.indexReader.document(docNum)).getValues("language"))) continue;
                for (String lang : languages) {
                    if (!lang.equals(locale.getLanguage())) continue;
                    return true;
                }
            }
        }
        catch (IOException e) {
            Loggers.logger.log(new ExtendedException(e));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDictionaryToDisk(Dictionary dict, Locale locale) throws ExtendedException {
        long numEntries = 0L;
        try {
            numEntries = dict.getNumberOfEntries();
        }
        catch (DLTException dlte) {
            // empty catch block
        }
        if (numEntries > 0L) {
            StringBuilder prevDicFileName = new StringBuilder(this.outputPrefix);
            prevDicFileName.append('-');
            prevDicFileName.append(locale.getLanguage());
            prevDicFileName.append('-');
            prevDicFileName.append(locale.getCountry());
            prevDicFileName.append(".dic");
            File prevDictionaryFile = new File(this.outputDir, prevDicFileName.toString());
            try {
                dict.contract();
                try {
                    DictionaryFileLock.getInstance().acquireLock(prevDictionaryFile);
                    if (prevDictionaryFile.isFile()) {
                        prevDictionaryFile.delete();
                    }
                    dict.save(prevDictionaryFile);
                }
                finally {
                    DictionaryFileLock.getInstance().releaseLock(prevDictionaryFile);
                }
            }
            catch (Exception e) {
                throw new ExtendedException(new Message("S0014E.QL_DICTIONARY_SAVE_FAILED", null == prevDictionaryFile ? "" : prevDictionaryFile.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    private Dictionary createEmptyDictionary() throws ExtendedException {
        Dictionary retDictionary = null;
        try {
            retDictionary = Dictionary.createDictionary((DictionaryInfo)new DictionaryInfo());
            retDictionary.registerType(15, "querylog featureset");
            retDictionary.registerType(1, "querylog morph");
            retDictionary.registerType(18, "querylog results count");
        }
        catch (DLTException dlte) {
            throw new ExtendedException(new Message("S0016E.EMPTY_DICTIONARY_CREATION_FAILED"), (Throwable)dlte);
        }
        return retDictionary;
    }

    private void addTermToDictionary(Dictionary dict, Term term) throws DLTException {
        FeatureSetGloss gloss1 = new FeatureSetGloss(0, 1, false, false, true, true);
        gloss1 = dict.addGloss(15, (Gloss)gloss1);
        StringCharacterIterator charIterator = new StringCharacterIterator(term.text());
        dict.addWord((CharacterIterator)charIterator, term.text().length(), (Gloss)gloss1);
    }

    private int calculateFrequency(Term term) throws IOException {
        int tf = 0;
        int df = 0;
        TermDocs termDoc = this.indexReader.termDocs(term);
        while (termDoc.next()) {
            int docNumber = termDoc.doc();
            if (this.indexReader.isDeleted(docNumber)) continue;
            ++df;
            tf += termDoc.freq();
        }
        return tf * df;
    }
}

