/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.spell;

import com.ibm.es.nuvo.cache.CacheException;
import com.ibm.es.nuvo.cache.ObjectCache;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.spell.SpellChecker;
import com.ibm.es.nuvo.spell.SpellCheckerLookupKey;
import com.ibm.es.nuvo.spell.SpellCheckerObjectCache;
import com.ibm.es.nuvo.spell.querylog.DictionaryWord;
import com.ibm.es.nuvo.tokenizer.Tokenizer;
import java.util.Locale;
import java.util.logging.Level;
import org.apache.lucene.index.IndexReader;

public class SpellSuggestionSearcher {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final int MAX_SUGGESTIONS_TO_RETURN = 5;
    private IndexReader indexReader = null;
    Tokenizer tokenizer = null;
    String language = null;
    String country = null;
    SpellChecker qlChecker = null;
    SpellChecker nlChecker = null;
    SpellCheckerLookupKey naturalLangLookupKey = null;
    SpellCheckerLookupKey queryLogLookupKey = null;

    public SpellSuggestionSearcher() {
        this(null, null, "en", "US");
    }

    public SpellSuggestionSearcher(IndexReader indexReader, Tokenizer tokenizer, String language, String country) {
        if (null != indexReader && null == tokenizer) {
            throw new NullPointerException("tokenizer is null");
        }
        if (null == indexReader) {
            tokenizer = null;
        }
        this.indexReader = indexReader;
        this.tokenizer = tokenizer;
        if (null == language) {
            language = "en";
        }
        if (null == country && language.equalsIgnoreCase("en")) {
            country = "US";
        }
        this.language = language;
        this.country = country;
        ObjectCache<SpellCheckerLookupKey, SpellChecker> cache = SpellCheckerObjectCache.getSpellCheckerObjectCache();
        this.queryLogLookupKey = new SpellCheckerLookupKey(SpellChecker.QueryLog, this.language, this.country);
        SpellChecker cachedObject = null;
        try {
            cachedObject = cache.get(this.queryLogLookupKey);
        }
        catch (CacheException e) {
            cachedObject = null;
        }
        if (null != cachedObject && cachedObject instanceof SpellChecker) {
            this.qlChecker = cachedObject;
        }
        this.naturalLangLookupKey = new SpellCheckerLookupKey(SpellChecker.NaturalLanguage, language, country);
        try {
            cachedObject = cache.get(this.naturalLangLookupKey);
        }
        catch (CacheException e) {
            if (Loggers.tracer.isLoggable(Level.FINE)) {
                ExtendedException eeToLog = new ExtendedException(new Message("S0018W.SPELL_SUGGESTION_LOOKUP_FAILED", SpellChecker.NaturalLanguage), (Throwable)e);
                Loggers.tracer.log(Level.FINE, eeToLog);
            }
            cachedObject = null;
        }
        if (null != cachedObject && cachedObject instanceof SpellChecker) {
            this.nlChecker = cachedObject;
        }
    }

    public String[] getSuggestions(String fieldName, String query) {
        String[] suggestions = null;
        if (null != this.qlChecker) {
            String queryToUse = DictionaryWord.normalizeQueryWords(query.toLowerCase(new Locale(this.language, this.country)));
            suggestions = this.getSuggestions(fieldName, queryToUse, this.qlChecker);
        }
        if ((null == suggestions || suggestions.length == 0) && null != this.nlChecker) {
            suggestions = this.getSuggestions(fieldName, query, this.nlChecker);
        }
        return suggestions;
    }

    private String[] getSuggestions(String fieldName, String query, SpellChecker spellChecker) {
        String[] suggestions = null;
        boolean refreshed = true;
        try {
            refreshed = spellChecker.tryRefresh();
        }
        catch (ExtendedException e) {
            if (Loggers.tracer.isLoggable(Level.FINE)) {
                ExtendedException eeToLog = new ExtendedException(new Message("S0018W.SPELL_SUGGESTION_LOOKUP_FAILED", SpellChecker.NaturalLanguage), (Throwable)e);
                Loggers.tracer.log(Level.FINE, eeToLog);
            }
            this.nlChecker = null;
        }
        if (refreshed) {
            try {
                suggestions = spellChecker.getSuggestions(fieldName, query, 5, this.indexReader, this.tokenizer);
            }
            catch (ExtendedException e) {
                suggestions = null;
            }
        }
        return suggestions;
    }
}

