/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.spell;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.MisspeltWord;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.normalizer.NormalizedStringBuffer;
import com.ibm.es.nuvo.normalizer.NormalizedStringBufferType1;
import com.ibm.es.nuvo.normalizer.NormalizedStringBufferType2;
import com.ibm.es.nuvo.spell.DictionaryFileNameFilter;
import com.ibm.es.nuvo.spell.ExtendedLookupDriver;
import com.ibm.es.nuvo.spell.SpellCheckerLookupKey;
import com.ibm.es.nuvo.tokenizer.ResultHandler;
import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.es.nuvo.tokenizer.Tokenizer;
import com.ibm.es.nuvo.tokenizer.TokenizerException;
import com.ibm.es.nuvo.tokenizer.TokenizerProcessInput;
import com.ibm.es.nuvo.tokenizer.XMLToken;
import com.ibm.es.nuvo.util.parser.ParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;

public class SpellChecker {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final boolean[] IS_META_CHAR_TABLE = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static boolean[] IS_META_NONSPACE_NONCCONTROL_CHAR_TABLE = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    public static final String NATURAL_LANGUAGE_DICTIONARY = "NL";
    public static final String QUERY_LOG_DICTIONARY = "QL";
    public static final Type NaturalLanguage = new Type("NL", true, true, false);
    public static final Type QueryLog = new Type("QL", false, true, true);
    private String language = null;
    private String country = null;
    private Type dictionaryType = NaturalLanguage;
    private ExtendedLookupDriver driver = null;
    private final ThreadLocal<TokenizedSuggestionHandler> suggestionHandlers = new ThreadLocal();

    private SpellChecker(Type dictionaryType, String language, String country) throws ExtendedException {
        if (null != dictionaryType) {
            this.dictionaryType = dictionaryType;
        }
        this.language = language;
        this.country = country;
        this.driver = SpellChecker.getLookupDriver(this.dictionaryType, this.language, this.country);
        if (null == this.driver) {
            Message msg = new Message("S0012E.DICTIONARY_DRIVER_LOOKUP_FAILED", this.dictionaryType.name, "", language, country);
            ExtendedException ee = new ExtendedException(msg);
            throw ee;
        }
    }

    public String[] getSuggestions(String query, int maxResponseSize, IndexReader indexReader, Tokenizer tokenizer) throws ExtendedException {
        return this.getSuggestions("_plain", query, maxResponseSize, indexReader, tokenizer);
    }

    public String[] getSuggestions(String fieldName, String query, int maxResponseSize, IndexReader indexReader, Tokenizer tokenizer) throws ExtendedException {
        try {
            String[] suggestions = null;
            suggestions = this.getSuggestionsFullQuery(fieldName, query, maxResponseSize, indexReader, tokenizer);
            if (null != suggestions) {
                return suggestions;
            }
            return this.getSuggestionsReplaceOneMisspelt(fieldName, query, maxResponseSize, indexReader, tokenizer);
        }
        catch (DLTException e) {
            Message msg = new Message("S0011E.SUGGESTION_LOOKUP_FAILED", query, maxResponseSize);
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            throw ee;
        }
    }

    private String[] getSuggestionsFullQuery(String fieldName, String query, int maxResponseSize, IndexReader indexReader, Tokenizer tokenizer) throws DLTException {
        String[] suggestions = null;
        suggestions = this.driver.match(query, maxResponseSize);
        if (null != suggestions) {
            if (suggestions[0].equals(query)) {
                return null;
            }
            if (null != (suggestions = this.filterByIndex(fieldName, suggestions, indexReader, tokenizer))) {
                return suggestions;
            }
        }
        return null;
    }

    private String[] getSuggestionsReplaceOneMisspelt(String fieldName, String query, int maxResponseSize, IndexReader indexReader, Tokenizer tokenizer) throws DLTException {
        ArrayList<MisspeltWord> badWords = this.driver.verify(query);
        int badWordsSize = badWords.size();
        if (badWordsSize < 2) {
            return null;
        }
        for (MisspeltWord badWord : badWords) {
            String[] filteredSuggestionsForBadWord;
            String notVerified;
            String[] suggestionsForBadword;
            String[] filteredWithoutBadWord;
            String queryWithoutBadWordPrefix = query.substring(0, badWord.start);
            String queryWithoutBadWordPostfix = query.substring(badWord.end, query.length());
            String queryWithoutBadWord = queryWithoutBadWordPrefix + queryWithoutBadWordPostfix;
            if (queryWithoutBadWord.length() > 0 && (null == (filteredWithoutBadWord = this.filterByIndex(fieldName, new String[]{queryWithoutBadWord}, indexReader, tokenizer)) || filteredWithoutBadWord.length == 0) || null != (suggestionsForBadword = this.driver.match(notVerified = query.substring(badWord.start, badWord.end), maxResponseSize)) && suggestionsForBadword[0].equals(notVerified) || null == (filteredSuggestionsForBadWord = this.filterByIndex(fieldName, suggestionsForBadword, indexReader, tokenizer)) || filteredSuggestionsForBadWord.length <= 0) continue;
            for (int i = 0; i < filteredSuggestionsForBadWord.length; ++i) {
                filteredSuggestionsForBadWord[i] = queryWithoutBadWordPrefix + filteredSuggestionsForBadWord[i] + queryWithoutBadWordPostfix;
            }
            return filteredSuggestionsForBadWord;
        }
        return null;
    }

    private String[] filterByIndex(String fieldName, String[] suggestions, IndexReader indexReader, Tokenizer tokenizer) {
        if (null == suggestions || suggestions.length == 0 || null == indexReader || null == tokenizer) {
            return suggestions;
        }
        ArrayList<String> filteredSuggestions = new ArrayList<String>(suggestions.length);
        TokenizedSuggestionHandler handler = this.suggestionHandlers.get();
        if (handler == null) {
            handler = new TokenizedSuggestionHandler(fieldName, new NormalizedStringBufferType1(), new NormalizedStringBufferType2(), indexReader);
            this.suggestionHandlers.set(handler);
        }
        handler.reset();
        for (int i = 0; i < suggestions.length; ++i) {
            handler.suggestion.setLength(0);
            handler.suggestion.append(suggestions[i]);
            try {
                handler.reset();
                tokenizer.process(handler, new TokenizerProcessInput(handler.suggestion, this.language, this.language));
                int minDF = handler.getMinimumDF();
                if (minDF <= 0) continue;
                filteredSuggestions.add(suggestions[i]);
                continue;
            }
            catch (TokenizerException te) {
                if (!Loggers.tracer.isLoggable(Level.FINE)) continue;
                Loggers.tracer.log(Level.FINE, te);
            }
        }
        if (0 == filteredSuggestions.size()) {
            return null;
        }
        String[] returnedSuggestions = new String[filteredSuggestions.size()];
        return filteredSuggestions.toArray(returnedSuggestions);
    }

    public void close() {
        this.driver.close();
    }

    public boolean tryRefresh() throws ExtendedException {
        try {
            return this.driver.tryRefreshDriver();
        }
        catch (Exception e) {
            Message msg = new Message("S0012E.DICTIONARY_DRIVER_LOOKUP_FAILED", this.dictionaryType.name, this.driver.getDictionaryFile(), this.language, this.country);
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            throw ee;
        }
    }

    public static SpellChecker getSpellChecker(Type dictionaryType, String language, String country) throws ExtendedException {
        return new SpellChecker(dictionaryType, language, country);
    }

    public static SpellChecker getSpellChecker(SpellCheckerLookupKey key) throws ExtendedException {
        return SpellChecker.getSpellChecker(key.getType(), key.getLanguage(), key.getCountry());
    }

    public static String getSpellPath() {
        String spellPath = GlobalConfiguration.getConfiguration().getSpellDirectory();
        if (null == spellPath || spellPath.length() == 0) {
            return null;
        }
        return spellPath;
    }

    public static File getSpellQLUpdatedPath() {
        return new File(SpellChecker.getSpellPath(), "updatedQLDics");
    }

    private static ExtendedLookupDriver getLookupDriver(Type dictionaryType, String language, String country) throws ExtendedException {
        ExtendedLookupDriver lookupDriver = null;
        String dictionaryName = dictionaryType.name;
        if (null == dictionaryName || null == language) {
            return null;
        }
        dictionaryName = dictionaryName.trim();
        language = language.trim();
        if (dictionaryName.length() == 0 || language.length() == 0) {
            return null;
        }
        File dictionaryPathDir = new File(SpellChecker.getSpellPath());
        if (!dictionaryPathDir.isDirectory()) {
            return null;
        }
        DictionaryFileNameFilter dicFileNameFilter = new DictionaryFileNameFilter(dictionaryName, language);
        File[] dicFiles = dictionaryPathDir.listFiles(dicFileNameFilter);
        if (dicFiles.length == 0) {
            return null;
        }
        File dicFileToUse = null;
        if (dicFiles.length > 1 && country != null) {
            for (int i = 0; null == dicFileToUse && i < dicFiles.length; ++i) {
                String extractedCountry = dicFiles[i].getName().substring(3, 5);
                if (!extractedCountry.equals(country)) continue;
                dicFileToUse = dicFiles[i];
            }
        }
        if (null == dicFileToUse) {
            dicFileToUse = dicFiles[0];
        }
        try {
            Locale localeToUse = null;
            localeToUse = null == country ? new Locale(language) : new Locale(language, country);
            lookupDriver = new ExtendedLookupDriver(dicFileToUse, dictionaryType, localeToUse);
        }
        catch (Exception e) {
            Message msg = new Message("S0012E.DICTIONARY_DRIVER_LOOKUP_FAILED", dictionaryName, dicFileToUse.getAbsolutePath(), language, country);
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            throw ee;
        }
        return lookupDriver;
    }

    public static boolean isMetaChar(char c) {
        if (c > '\u007f') {
            return false;
        }
        return IS_META_CHAR_TABLE[c];
    }

    public static boolean containsMetaChar(String str) {
        if (null != str && str.length() > 0) {
            for (int i = 0; i < str.length(); ++i) {
                if (!SpellChecker.isMetaChar(str.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMetaNonSpaceNonControlChar(char c) {
        if (c > '\u007f') {
            return false;
        }
        return IS_META_NONSPACE_NONCCONTROL_CHAR_TABLE[c];
    }

    public static boolean containsMetaNonSpaceNonControlChar(String str) {
        if (null != str && str.length() > 0) {
            for (int i = 0; i < str.length(); ++i) {
                if (!SpellChecker.isMetaNonSpaceNonControlChar(str.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("SpellChecker config.xml");
            System.exit(0);
        }
        try {
            GlobalConfiguration.initialize(args[0]);
            BufferedReader inReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            while (true) {
                System.out.println("Input query (empty to quit):");
                System.out.print(">");
                System.out.flush();
                String query = inReader.readLine();
                if (null == query || query.length() == 0) {
                    System.exit(0);
                }
                Type type = null;
                do {
                    System.out.println("Input dictionary type [NL or QL] (empty = NL):");
                    System.out.print(">");
                    System.out.flush();
                    String typeStr = inReader.readLine();
                    typeStr = null != typeStr ? typeStr.trim() : "";
                    if (typeStr.length() == 0 || typeStr.equalsIgnoreCase(NATURAL_LANGUAGE_DICTIONARY)) {
                        type = NaturalLanguage;
                        continue;
                    }
                    if (!typeStr.equalsIgnoreCase(QUERY_LOG_DICTIONARY)) continue;
                    type = QueryLog;
                } while (type == null);
                String lang = Locale.getDefault().getLanguage();
                System.out.println("Input 2 letter language (empty = " + lang + "):");
                System.out.print(">");
                System.out.flush();
                String langStr = inReader.readLine();
                langStr = null != langStr ? langStr.trim() : "";
                if (langStr.length() > 0) {
                    lang = langStr;
                }
                String country = Locale.getDefault().getCountry();
                System.out.println("Input 2 letter country (empty = " + country + "):");
                System.out.print(">");
                System.out.flush();
                String countryStr = inReader.readLine();
                countryStr = null != countryStr ? countryStr.trim() : "";
                if (countryStr.length() > 0) {
                    country = countryStr;
                }
                try {
                    SpellChecker checker = SpellChecker.getSpellChecker(type, lang, country);
                    String[] suggestions = checker.getSuggestions(query, 10, null, null);
                    System.out.println();
                    System.out.println("Suggestions found:");
                    if (null != suggestions) {
                        for (int i = 0; i < suggestions.length; ++i) {
                            System.out.println("[" + suggestions[i] + "]");
                        }
                    }
                    System.out.println();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (ParseException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static final class TokenizedSuggestionHandler
    implements ResultHandler {
        private IndexReader indexReader = null;
        private NormalizedStringBuffer suggestion = null;
        private NormalizedStringBuffer type2Normalizer = null;
        private String fieldName = null;
        private int minDF = Integer.MAX_VALUE;

        public TokenizedSuggestionHandler(String fieldName, NormalizedStringBuffer suggestion, NormalizedStringBuffer type2Normalizer, IndexReader indexReader) {
            this.fieldName = fieldName;
            this.suggestion = suggestion;
            this.type2Normalizer = type2Normalizer;
            this.indexReader = indexReader;
        }

        public TokenizedSuggestionHandler(NormalizedStringBuffer suggestion, NormalizedStringBuffer type2Normalizer, IndexReader indexReader) {
            this("_plain", suggestion, type2Normalizer, indexReader);
        }

        public void addToken(TToken token, int begin, int end) {
            if (this.minDF > 0) {
                int docFreq = 0;
                TToken.Type tokenType = token.getType();
                if (TToken.Type.ORIGINAL == tokenType || TToken.Type.BOTH == tokenType) {
                    this.type2Normalizer.setLength(0);
                    this.type2Normalizer.append(this.suggestion.subSequence(begin, end));
                    Term t = new Term(this.fieldName, this.type2Normalizer.toString());
                    try {
                        docFreq = this.indexReader.docFreq(t);
                    }
                    catch (Exception e) {
                        docFreq = 0;
                    }
                    if (this.minDF > docFreq) {
                        this.minDF = docFreq;
                    }
                }
            }
        }

        public void addXMLToken(XMLToken xmlToken) {
            System.out.println("SpellChecker got XML token: should never happen.");
        }

        public void addField(String name, String value) {
        }

        public void close() {
            this.minDF = Integer.MAX_VALUE;
        }

        public void reset() {
            this.minDF = Integer.MAX_VALUE;
        }

        public boolean isAllFound() {
            return this.minDF == 0;
        }

        public int getMinimumDF() {
            return this.minDF;
        }
    }

    public static final class Type {
        private String name = null;
        boolean whitespaceTokenization = false;
        boolean strictMWU = true;
        boolean extraRanking = true;

        private Type(String name, boolean whitespaceTokenization, boolean strictMWU, boolean extraRanking) {
            this.name = name;
            this.whitespaceTokenization = whitespaceTokenization;
            this.strictMWU = strictMWU;
            this.extraRanking = extraRanking;
        }

        public boolean equals(Type toCompare) {
            if (this.name == null || toCompare.name == null) {
                return false;
            }
            return this.name.equals(toCompare.name);
        }

        public boolean equals(Object toCompare) {
            return toCompare instanceof Type && this.equals((Type)toCompare);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name + " " + this.extraRanking + " " + this.strictMWU + " " + this.whitespaceTokenization;
        }
    }
}

