/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.spell;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.MisspeltWord;
import com.ibm.dltj.SpellCheckerSession;
import com.ibm.dltj.nondeterm.AdvancedLookupDriver;
import com.ibm.es.nuvo.spell.DictionaryFileLock;
import com.ibm.es.nuvo.spell.SpellChecker;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedLookupDriver {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private File dicFile = null;
    private File updatedDicFile = null;
    private AdvancedLookupDriver driver = null;
    private SpellChecker.Type dictionaryType = null;
    private Locale locale = null;
    private SpellCheckerSession spellVerifyDriver = null;

    public ExtendedLookupDriver(File dictionaryFile, SpellChecker.Type dictionaryType, Locale locale) throws DLTException {
        this.dicFile = dictionaryFile;
        this.updatedDicFile = new File(SpellChecker.getSpellQLUpdatedPath(), this.dicFile.getName());
        this.dictionaryType = dictionaryType;
        this.locale = locale;
        this.initDriver();
    }

    private synchronized void initDriver() throws DLTException {
        Dictionary[] masters = new Dictionary[]{new Dictionary(this.dicFile)};
        this.driver = new AdvancedLookupDriver(masters);
        this.spellVerifyDriver = new SpellCheckerSession(masters, 0, this.locale.toString());
        this.driver.allowExactMatch = true;
        this.driver.whiteSpaceTokenization = this.dictionaryType.whitespaceTokenization;
        this.driver.extraRanking = this.dictionaryType.extraRanking;
    }

    public File getDictionaryFile() {
        return this.dicFile;
    }

    public boolean isCurrent() {
        return !this.updatedDicFile.isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] match(String query, int maxResponseSize) throws DLTException {
        String[] suggestions = null;
        ExtendedLookupDriver extendedLookupDriver = this;
        synchronized (extendedLookupDriver) {
            suggestions = this.driver.match(query, 2, maxResponseSize);
        }
        if (null != suggestions) {
            if (suggestions.length == 0) {
                return null;
            }
            StringTokenizer tokenizer = new StringTokenizer(query);
            int numOfWords = tokenizer.countTokens();
            ArrayList<String> filteredSuggestions = new ArrayList<String>();
            for (String suggestion : suggestions) {
                int suggestionWordcount = new StringTokenizer(suggestion).countTokens();
                if (suggestionWordcount != numOfWords) continue;
                filteredSuggestions.add(suggestion);
            }
            if (0 == filteredSuggestions.size()) {
                suggestions = null;
            } else {
                suggestions = new String[filteredSuggestions.size()];
                suggestions = filteredSuggestions.toArray(suggestions);
            }
        }
        return suggestions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MisspeltWord> verify(String text) throws DLTException {
        List badWords = null;
        this.spellVerifyDriver.open();
        try {
            badWords = this.spellVerifyDriver.checkSpelling(text);
        }
        finally {
            this.spellVerifyDriver.close();
        }
        ArrayList<MisspeltWord> filteredBadWords = new ArrayList<MisspeltWord>();
        for (MisspeltWord badWord : badWords) {
            if (this.canIgnore(badWord)) continue;
            filteredBadWords.add(badWord);
        }
        return filteredBadWords;
    }

    private boolean canIgnore(MisspeltWord badWord) {
        boolean canIgnore = false;
        switch (badWord.type) {
            case 104: {
                canIgnore = true;
                break;
            }
            case 1: {
                canIgnore = true;
            }
        }
        return canIgnore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean tryRefreshDriver() throws DLTException {
        if (!this.isCurrent()) {
            boolean locked = false;
            try {
                locked = DictionaryFileLock.getInstance().tryLock(this.updatedDicFile);
                if (locked) {
                    this.driver.dispose();
                    this.dicFile.delete();
                    this.updatedDicFile.renameTo(this.dicFile);
                    this.initDriver();
                }
                boolean bl = locked;
                return bl;
            }
            finally {
                if (locked) {
                    DictionaryFileLock.getInstance().releaseLock(this.updatedDicFile);
                }
            }
        }
        return true;
    }

    public synchronized void close() {
        this.driver.dispose();
    }
}

