/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.spell;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;

public class DictionaryFileLock {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static DictionaryFileLock dicFileLock = new DictionaryFileLock();
    private Map<String, ReentrantLock> namedLockSet = Collections.synchronizedMap(new TreeMap());

    private DictionaryFileLock() {
    }

    public void acquireLock(File dicFile) {
        ReentrantLock lockObject = this.namedLockSet.get(dicFile.getName());
        if (null == lockObject) {
            lockObject = new ReentrantLock();
            this.namedLockSet.put(dicFile.getName(), lockObject);
        }
        lockObject.lock();
    }

    public boolean tryLock(File dicFile) {
        ReentrantLock lockObject = this.namedLockSet.get(dicFile.getName());
        if (null == lockObject) {
            lockObject = new ReentrantLock();
            this.namedLockSet.put(dicFile.getName(), lockObject);
        }
        return lockObject.tryLock();
    }

    public void releaseLock(File dicFile) {
        ReentrantLock lockObject = this.namedLockSet.get(dicFile.getName());
        if (null != lockObject) {
            lockObject.unlock();
        }
    }

    public static DictionaryFileLock getInstance() {
        return dicFileLock;
    }
}

