/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.util;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;

public abstract class StoredDocumentLoader {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static FieldSelector loadAllSelector = new FieldSelector(){
        private static final long serialVersionUID = 1L;

        public FieldSelectorResult accept(String fieldName) {
            return FieldSelectorResult.LOAD;
        }
    };

    public Document loadStoredDocument(IndexReader reader, int docId) throws ExtendedException {
        return this.loadStoredDocument(reader, docId, loadAllSelector);
    }

    public Document loadStoredDocument(IndexReader reader, int docId, FieldSelector fieldSelector) throws ExtendedException {
        try {
            return this.doLoadStoredDocument(reader, docId, fieldSelector);
        }
        catch (Exception e) {
            Message msg = new Message("S0075E.CANNOT_LOAD_STORED_DOCUMENT");
            msg.addArgument(docId);
            throw new ExtendedException(msg, (Throwable)e);
        }
    }

    protected abstract Document doLoadStoredDocument(IndexReader var1, int var2, FieldSelector var3) throws Exception;

    public static class SimpleStoredDocumentLoader
    extends StoredDocumentLoader {
        protected Document doLoadStoredDocument(IndexReader reader, int docId, FieldSelector fieldSelector) throws IOException {
            return reader.document(docId, fieldSelector);
        }
    }
}

