/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.util;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.admin.ui.beans.CustomUiBean;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.httplistener.HttpListenerManager;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class RequestUtils {
    public static CustomUiBean getCustomUiBeanValues(HttpServletRequest request) {
        CustomUiBean customUiBean = new CustomUiBean(request.getServerName());
        if (request.getParameter("preview") != null && request.getParameter("preview").toLowerCase().equals("true")) {
            customUiBean.loadValuesFromPropertiesFile(CustomUiBean.TEMPORARY_FILE_FLAG, request.getLocale());
            RequestUtils.savePreviewUrlString(request);
        } else {
            customUiBean.loadValuesFromPropertiesFile(CustomUiBean.PERSISTENT_FILE_FLAG, request.getLocale());
        }
        return customUiBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePreviewUrlString(HttpServletRequest request) {
        String absWhitneyPackageDir = GlobalConfiguration.getConfiguration().getInstallPath();
        String fileName = absWhitneyPackageDir + "/config/customization/" + "UrlRequestString.properties";
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String reqStr = request.getQueryString();
        String searchURL = HttpListenerManager.getSingleInstanceListenerServer().getSearchAppURL(request.getServerName());
        String completeUrlStr = searchURL + contextPath + servletPath + "?" + reqStr;
        Properties properties = new Properties();
        FileOutputStream fos = null;
        try {
            properties.setProperty("urlRequestString", completeUrlStr);
            fos = new FileOutputStream(fileName);
            properties.store(fos, null);
        }
        catch (IOException e) {
            if (Loggers.logger.isLoggable(Level.WARNING)) {
                Message msg = new Message("A0710E.UNABLE_TO_ACCESS_CUSTOMIZATION_FILE", fileName);
                Loggers.logger.log(Level.WARNING, msg);
                System.err.println(msg.getFormattedText());
            }
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception ignore) {}
        }
    }
}

