/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.util;

import com.ibm.es.nuvo.cache.CacheException;
import com.ibm.es.nuvo.cache.CacheLoader;
import com.ibm.es.nuvo.cache.ObjectCache;
import com.ibm.es.nuvo.search.util.StoredDocumentLoader;
import java.util.Properties;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.IndexReader;

public class CachingStoredDocumentLoader
extends StoredDocumentLoader {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final int CACHE_SIZE = 50;
    private static final Document DUMMY_CACHE_VALUE = new Document();
    private static Properties cacheProperties = new Properties();
    private static ObjectCache<CacheKey, Document> cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document doLoadStoredDocument(IndexReader reader, int docId, FieldSelector fieldSelector) throws Exception {
        IndexReader indexReader = reader;
        synchronized (indexReader) {
            CacheKey key = new CacheKey(reader, docId, fieldSelector);
            Document d = cache.get(key);
            if (d == DUMMY_CACHE_VALUE) {
                d = reader.document(docId, fieldSelector);
                cache.replace(key, d, true);
            }
            return d;
        }
    }

    static {
        cacheProperties.put("cache.size", Integer.toString(50));
        cacheProperties.put("cache.name", "<Document Loader Cache>");
        cache = new ObjectCache(cacheProperties);
        cache.setCacheLoader(new CacheLoader<CacheKey, Document>(){

            @Override
            public Document load(CacheKey name) throws CacheException {
                return DUMMY_CACHE_VALUE;
            }
        });
    }

    private static class CacheKey {
        private IndexReader reader;
        private int docId;
        private FieldSelector fieldSelector;

        CacheKey(IndexReader reader, int docId, FieldSelector fieldSelector) {
            this.reader = reader;
            this.docId = docId;
            this.fieldSelector = fieldSelector;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CacheKey)) {
                return false;
            }
            return this.equals((CacheKey)o);
        }

        public boolean equals(CacheKey o) {
            return this.docId == o.docId && this.reader.equals(o.reader) && this.fieldSelector.equals(o.fieldSelector);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.docId;
            result = 37 * result + this.reader.hashCode();
            result = 37 * result + this.fieldSelector.hashCode();
            return result;
        }
    }
}

