/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.summarizer.util;

import com.ibm.es.nuvo.search.summarizer.util.TokenVectorIterator;
import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.es.nuvo.tokenizer.TokenVector;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenVectorBuffer
extends TokenVectorIterator {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private TokenVector tokenVector;
    private int bufferSize;
    private List<Token> buffer = new LinkedList<Token>();
    private List<String> tokenStrings = new LinkedList<String>();
    private boolean endOfVectorReached;
    private boolean first;

    public TokenVectorBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public void doSetTokenVector(TokenVector tv) {
        this.tokenVector = tv;
        this.endOfVectorReached = false;
        this.buffer.clear();
        this.tokenStrings.clear();
        this.first = true;
        this.fillBuffer();
    }

    public List<String> getTokenStrings() {
        return this.tokenStrings;
    }

    @Override
    public String getCurrentToken() {
        if (this.tokenStrings.isEmpty()) {
            return null;
        }
        return this.tokenStrings.get(0);
    }

    @Override
    public Token next() {
        if (this.first) {
            this.first = false;
        } else {
            if (!this.buffer.isEmpty() && this.isTextToken(this.buffer.remove(0))) {
                this.tokenStrings.remove(0);
            }
            if (!this.endOfVectorReached) {
                this.loadNextToken();
            }
        }
        if (this.buffer.isEmpty()) {
            return null;
        }
        return this.buffer.get(0);
    }

    @Override
    public int skip(int n) {
        if (n <= 0) {
            return 0;
        }
        if (!this.first && !this.buffer.isEmpty() && this.isTextToken(this.buffer.remove(0))) {
            this.tokenStrings.remove(0);
        }
        int skipped = 0;
        Iterator<Token> it = this.buffer.iterator();
        while (it.hasNext()) {
            Token next = it.next();
            skipped += next.getPositionIncrement();
            it.remove();
            if (this.isTextToken(next)) {
                this.tokenStrings.remove(0);
            }
            if (skipped < n) continue;
            break;
        }
        if (skipped < n) {
            skipped += this.tokenVector.skip(n - skipped);
        }
        this.first = true;
        this.fillBuffer();
        return skipped;
    }

    private boolean isTextToken(Token token) {
        return TToken.Type.ORIGINAL.equals(token.type()) || TToken.Type.BOTH.equals(token.type()) || TToken.Type.NGRAM.equals(token.type());
    }

    private void loadNextToken() {
        Token token = this.tokenVector.next();
        while (token != null) {
            this.buffer.add(token);
            if (this.isTextToken(token)) {
                this.tokenStrings.add(this.normalize(token.termText()));
                break;
            }
            token = this.tokenVector.next();
        }
        if (token == null) {
            this.endOfVectorReached = true;
        }
    }

    private void fillBuffer() {
        for (int i = this.buffer.size(); i < this.bufferSize; ++i) {
            this.loadNextToken();
            if (this.endOfVectorReached) break;
        }
    }
}

