/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.summarizer.util;

import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectPool<T> {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private final List<T> pool;
    private int maxSize;

    protected abstract T initItem();

    public ObjectPool(int initSize, int maxSize) {
        this.maxSize = maxSize;
        this.pool = new LinkedList<T>();
        for (int i = 0; i < initSize; ++i) {
            this.pool.add(this.initItem());
        }
    }

    public final synchronized void releaseItem(T item) {
        if (this.pool.size() < this.maxSize) {
            this.pool.add(item);
        }
    }

    public final synchronized T requestItem() {
        if (this.pool.isEmpty()) {
            return this.initItem();
        }
        return this.pool.remove(0);
    }
}

