/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.summarizer.queryterms.special;

import com.ibm.es.nuvo.search.summarizer.queryterms.HighlightTerm;
import com.ibm.es.nuvo.search.summarizer.queryterms.special.TermMatcher;
import com.ibm.es.nuvo.search.summarizer.queryterms.special.WildcardMatcher;
import com.ibm.es.nuvo.search.summarizer.util.TokenVectorBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardPhraseMatcher
extends TermMatcher {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private List<HighlightTerm> terms;
    private Map<HighlightTerm, WildcardMatcher> wildcardMatchers;

    public WildcardPhraseMatcher(List<HighlightTerm> terms) {
        super(terms.get(0).getField());
        this.terms = terms;
        this.wildcardMatchers = new HashMap<HighlightTerm, WildcardMatcher>();
        for (HighlightTerm curTerm : this.terms) {
            if (!curTerm.isWildcard()) continue;
            this.wildcardMatchers.put(curTerm, new WildcardMatcher(curTerm.getTerm()));
        }
    }

    @Override
    public int matches() {
        if (this.tokenVectorIterator instanceof TokenVectorBuffer) {
            List<String> buffer = ((TokenVectorBuffer)this.tokenVectorIterator).getTokenStrings();
            if (buffer.size() < this.terms.size()) {
                return 0;
            }
            for (int i = 0; i < this.terms.size(); ++i) {
                if (!(this.terms.get(i).isWildcard() ? !this.wildcardMatchers.get(this.terms.get(i)).matches(buffer.get(i)) : !this.terms.get(i).getTermText().equals(buffer.get(i)))) continue;
                return 0;
            }
            return this.terms.size();
        }
        return 0;
    }

    public String toString() {
        return "WildcardPhraseMatcher: " + this.terms;
    }
}

