/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.summarizer.queryterms.special;

import com.ibm.es.nuvo.search.summarizer.queryterms.special.TermMatcher;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.WildcardTermEnum;

public class WildcardMatcher
extends TermMatcher {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String queryTerm;
    private String prefix = "";
    private int prefixLength = 0;
    private boolean isSingleCharacterWildcard;

    public WildcardMatcher(Term term) {
        super(term.field());
        this.queryTerm = term.text();
        this.isSingleCharacterWildcard = this.queryTerm.length() == 2;
        int sidx = this.queryTerm.indexOf(42);
        int cidx = this.queryTerm.indexOf(63);
        int idx = sidx;
        if (idx == -1) {
            idx = cidx;
        } else if (cidx >= 0) {
            idx = Math.min(idx, cidx);
        }
        this.prefix = this.queryTerm.substring(0, idx);
        this.prefixLength = this.prefix.length();
        this.queryTerm = this.queryTerm.substring(this.prefixLength);
    }

    public int matches() {
        String termText = this.tokenVectorIterator.getCurrentToken();
        if (termText == null || !this.matches(termText)) {
            return 0;
        }
        return 1;
    }

    boolean matches(String termText) {
        return termText.startsWith(this.prefix) && WildcardTermEnum.wildcardEquals((String)this.queryTerm, (int)0, (String)termText, (int)this.prefixLength);
    }

    public boolean isSingleCharacterWildcard() {
        return this.isSingleCharacterWildcard;
    }

    public String toString() {
        return "WildcardMatcher: " + this.prefix + this.queryTerm;
    }
}

