/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.summarizer.queryterms.special;

import com.ibm.es.nuvo.search.summarizer.queryterms.special.TermMatcher;
import org.apache.lucene.index.Term;

public class FuzzyTermMatcher
extends TermMatcher {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int TYPICAL_LONGEST_WORD_IN_INDEX = 19;
    private float minSimilarity;
    private int[][] d;
    private String queryTerm;
    private final String text;
    private final String prefix;
    private final float scale_factor;
    private final int[] maxDistances = new int[19];

    public FuzzyTermMatcher(Term term, float minSimilarity, int prefixLength) {
        super(term.field());
        this.queryTerm = term.text();
        this.minSimilarity = Math.min(1.0f, Math.max(0.0f, minSimilarity));
        prefixLength = Math.max(0, prefixLength);
        this.scale_factor = 1.0f / (1.0f - this.minSimilarity);
        int fullSearchTermLength = this.queryTerm.length();
        int realPrefixLength = prefixLength > fullSearchTermLength ? fullSearchTermLength : prefixLength;
        this.text = this.queryTerm.substring(realPrefixLength);
        this.prefix = this.queryTerm.substring(0, realPrefixLength);
        this.initializeMaxDistances();
        this.d = this.initDistanceArray();
    }

    public int matches() {
        String target;
        float similarity;
        String termText = this.tokenVectorIterator.getCurrentToken();
        if (termText == null) {
            return 0;
        }
        if (termText.startsWith(this.prefix) && (similarity = this.similarity(target = termText.substring(this.prefix.length()))) > this.minSimilarity) {
            return 1;
        }
        return 0;
    }

    public final float difference(float similarity) {
        return (similarity - this.minSimilarity) * this.scale_factor;
    }

    private static final int min(int a, int b, int c) {
        int t = a < b ? a : b;
        return t < c ? t : c;
    }

    private final int[][] initDistanceArray() {
        return new int[this.text.length() + 1][19];
    }

    private final float similarity(String target) {
        int i;
        int m = target.length();
        int n = this.text.length();
        if (n == 0) {
            return this.prefix.length() == 0 ? 0.0f : 1.0f - (float)m / (float)this.prefix.length();
        }
        if (m == 0) {
            return this.prefix.length() == 0 ? 0.0f : 1.0f - (float)n / (float)this.prefix.length();
        }
        int maxDistance = this.getMaxDistance(m);
        if (maxDistance < Math.abs(m - n)) {
            return 0.0f;
        }
        if (this.d[0].length <= m) {
            this.growDistanceArray(m);
        }
        for (i = 0; i <= n; ++i) {
            this.d[i][0] = i;
        }
        for (int j = 0; j <= m; ++j) {
            this.d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            int bestPossibleEditDistance = m;
            char s_i = this.text.charAt(i - 1);
            for (int j = 1; j <= m; ++j) {
                this.d[i][j] = s_i != target.charAt(j - 1) ? FuzzyTermMatcher.min(this.d[i - 1][j], this.d[i][j - 1], this.d[i - 1][j - 1]) + 1 : FuzzyTermMatcher.min(this.d[i - 1][j] + 1, this.d[i][j - 1] + 1, this.d[i - 1][j - 1]);
                bestPossibleEditDistance = Math.min(bestPossibleEditDistance, this.d[i][j]);
            }
            if (i <= maxDistance || bestPossibleEditDistance <= maxDistance) continue;
            return 0.0f;
        }
        return 1.0f - (float)this.d[n][m] / (float)(this.prefix.length() + Math.min(n, m));
    }

    private void growDistanceArray(int m) {
        for (int i = 0; i < this.d.length; ++i) {
            this.d[i] = new int[m + 1];
        }
    }

    private final int getMaxDistance(int m) {
        return m < this.maxDistances.length ? this.maxDistances[m] : this.calculateMaxDistance(m);
    }

    private void initializeMaxDistances() {
        for (int i = 0; i < this.maxDistances.length; ++i) {
            this.maxDistances[i] = this.calculateMaxDistance(i);
        }
    }

    private int calculateMaxDistance(int m) {
        return (int)((1.0f - this.minSimilarity) * (float)(Math.min(this.text.length(), m) + this.prefix.length()));
    }

    public String toString() {
        return "FuzzyTefrmMatcher: " + this.queryTerm;
    }
}

