/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.summarizer.queryterms;

import com.ibm.es.nuvo.search.summarizer.queryterms.HighlightTerm;
import com.ibm.es.nuvo.search.summarizer.queryterms.special.TermMatcher;
import com.ibm.es.nuvo.search.summarizer.queryterms.special.WildcardMatcher;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WeightedTerm
implements Comparable<WeightedTerm> {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private float weight;
    private boolean isSpecialTerm;
    private boolean isSingleCharacterWildcard = false;
    private List<HighlightTerm> terms;
    private TermMatcher termMatcher = null;
    private int length = 0;

    private WeightedTerm(boolean isSpecialTerm) {
        this.isSpecialTerm = isSpecialTerm;
        if (!isSpecialTerm) {
            this.terms = new ArrayList<HighlightTerm>();
        }
    }

    static WeightedTerm createSpecialTerm(TermMatcher termMatcher, int length) {
        WeightedTerm wt = new WeightedTerm(true);
        wt.length = length;
        wt.termMatcher = termMatcher;
        if (termMatcher instanceof WildcardMatcher) {
            wt.isSingleCharacterWildcard = ((WildcardMatcher)termMatcher).isSingleCharacterWildcard();
        }
        return wt;
    }

    static WeightedTerm createWeightedTerm() {
        return new WeightedTerm(false);
    }

    TermMatcher getTermMatcher() {
        return this.termMatcher;
    }

    public boolean isSingleCharacterWildcard() {
        return this.isSingleCharacterWildcard;
    }

    public boolean isSpecialTerm() {
        return this.isSpecialTerm;
    }

    void addSingleTerm(HighlightTerm term) {
        if (this.isSpecialTerm) {
            return;
        }
        this.terms.add(term);
        this.weight = this.terms.size();
    }

    void addTerms(List<HighlightTerm> termList) {
        if (this.isSpecialTerm) {
            return;
        }
        this.terms.addAll(termList);
    }

    public HighlightTerm getTermArray(int index) {
        if (this.isSpecialTerm) {
            return null;
        }
        return this.terms.get(index);
    }

    public String getField() {
        if (this.isSpecialTerm) {
            return this.termMatcher.getField();
        }
        return this.getTermArray(0).getField();
    }

    public int length() {
        if (this.isSpecialTerm) {
            return this.length;
        }
        return this.terms.size();
    }

    public float getWeight() {
        return this.weight;
    }

    @Override
    public int compareTo(WeightedTerm other) {
        if (this.weight < other.weight) {
            return 1;
        }
        if (this.weight > other.weight) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        if (this.isSpecialTerm) {
            return "WeightedTerm: " + this.termMatcher.toString();
        }
        return "WeightedTerm: " + this.terms;
    }
}

