/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.summarizer.queryterms;

import com.ibm.es.nuvo.search.summarizer.queryterms.HighlightTerm;
import com.ibm.es.nuvo.search.summarizer.queryterms.WeightedTerm;
import com.ibm.es.nuvo.search.summarizer.queryterms.special.FuzzyTermMatcher;
import com.ibm.es.nuvo.search.summarizer.queryterms.special.WildcardMatcher;
import com.ibm.es.nuvo.search.summarizer.queryterms.special.WildcardPhraseMatcher;
import com.ibm.es.nuvo.search.summarizer.util.SimpleTokenVectorIterator;
import com.ibm.es.nuvo.search.summarizer.util.TokenVectorBuffer;
import com.ibm.es.nuvo.search.summarizer.util.TokenVectorIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.Term;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighlightQueryTerms {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private TokenVectorIterator tokenVectorIterator;
    private List<WeightedTerm> queryTerms = new ArrayList<WeightedTerm>();
    private float minWeight = 1.0f;
    private int tokenVectorBufferSize = 1;
    private boolean hasSpecialTerms = false;
    private int numberOfNormalTerms = 0;
    private boolean initialized = false;

    public void addSingleTerm(HighlightTerm highlightTerm) {
        if (highlightTerm.isWildcard()) {
            this.queryTerms.add(WeightedTerm.createSpecialTerm(new WildcardMatcher(highlightTerm.getTerm()), 1));
            this.hasSpecialTerms = true;
        } else {
            WeightedTerm termToAppend = WeightedTerm.createWeightedTerm();
            termToAppend.addSingleTerm(highlightTerm);
            this.queryTerms.add(termToAppend);
            ++this.numberOfNormalTerms;
        }
    }

    public void addFuzzyTerm(Term term, float minSimilarity, int prefixLength) {
        this.queryTerms.add(WeightedTerm.createSpecialTerm(new FuzzyTermMatcher(term, minSimilarity, prefixLength), 1));
        this.hasSpecialTerms = true;
    }

    public void addPhrase(List<HighlightTerm> termList) {
        if (termList.size() == 1) {
            this.addSingleTerm(termList.get(0));
            return;
        }
        for (HighlightTerm curTerm : termList) {
            if (!curTerm.isWildcard()) continue;
            this.queryTerms.add(WeightedTerm.createSpecialTerm(new WildcardPhraseMatcher(termList), termList.size()));
            this.hasSpecialTerms = true;
            this.setBufferSize(termList.size());
            return;
        }
        WeightedTerm termToAppend = WeightedTerm.createWeightedTerm();
        termToAppend.addTerms(termList);
        this.queryTerms.add(termToAppend);
        ++this.numberOfNormalTerms;
    }

    private void setBufferSize(int size) {
        this.tokenVectorBufferSize = Math.max(this.tokenVectorBufferSize, size);
    }

    public WeightedTerm getWeightedTerm(int index) {
        return this.queryTerms.get(index);
    }

    public boolean hasSpecialTerms() {
        return this.hasSpecialTerms;
    }

    public TokenVectorIterator getTokenVectorIterator() {
        return this.tokenVectorIterator;
    }

    public int length() {
        return this.queryTerms.size();
    }

    public int getNumberOfNormalTerms() {
        return this.numberOfNormalTerms;
    }

    public float getMinWeight() {
        return this.minWeight;
    }

    public boolean isSpecialQuery() {
        return this.hasSpecialTerms && this.numberOfNormalTerms == 0;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.sort();
        this.tokenVectorIterator = this.tokenVectorBufferSize > 1 ? new TokenVectorBuffer(this.tokenVectorBufferSize) : new SimpleTokenVectorIterator();
        for (WeightedTerm curTerm : this.queryTerms) {
            if (!curTerm.isSpecialTerm()) continue;
            curTerm.getTermMatcher().setTokenVectorIterator(this.tokenVectorIterator);
        }
        this.initialized = true;
    }

    private void sort() {
        WeightedTerm[] sortedTerms = this.queryTerms.toArray(new WeightedTerm[this.queryTerms.size()]);
        this.queryTerms.clear();
        Arrays.sort(sortedTerms, new Comparator<WeightedTerm>(){

            @Override
            public int compare(WeightedTerm t1, WeightedTerm t2) {
                return t2.length() - t1.length();
            }
        });
        for (int i = 0; i < sortedTerms.length; ++i) {
            this.queryTerms.add(sortedTerms[i]);
            this.minWeight = Math.min(this.minWeight, sortedTerms[i].getWeight());
        }
    }

    public void specialTermMatches(BitSet hits) {
        for (int i = 0; i < this.queryTerms.size(); ++i) {
            int curMatchLength;
            WeightedTerm curTerm = this.queryTerms.get(i);
            if (!curTerm.isSpecialTerm() || (curMatchLength = curTerm.getTermMatcher().matches()) <= 0) continue;
            hits.set(i);
        }
    }

    public String toString() {
        return this.queryTerms.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Match
    implements Comparable<Match> {
        private int queryTermIndex;
        private int length;

        public Match(int queryTermIndex, int length) {
            this.queryTermIndex = queryTermIndex;
            this.length = length;
        }

        public int getQueryTermIndex() {
            return this.queryTermIndex;
        }

        public int getLength() {
            return this.length;
        }

        @Override
        public int compareTo(Match other) {
            return other.length - this.length;
        }
    }
}

