/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.summarizer.highlighter;

import com.ibm.es.nuvo.search.summarizer.Summarizer;
import com.ibm.es.nuvo.search.summarizer.documentvectorizer.DocumentVector;
import com.ibm.es.nuvo.search.summarizer.fragmentbuilder.Fragment;
import com.ibm.es.nuvo.search.summarizer.highlighter.SummaryFormatter;
import com.ibm.es.nuvo.search.summarizer.queryterms.HighlightQueryTerms;
import com.ibm.es.nuvo.search.summarizer.queryterms.WeightedTerm;
import com.ibm.es.nuvo.search.summarizer.util.TokenUtils;
import com.ibm.es.nuvo.search.summarizer.util.TokenVectorIterator;
import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.es.nuvo.tokenizer.TokenVector;
import java.util.BitSet;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.analysis.Token;

public class Highlighter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private SummaryFormatter formatter;
    private StringBuilder buffer;
    private SortedMap<Integer, HighlightPostfixPosition> highlightPostfixPositions;
    private BitSet hitIndexSorter;

    public Highlighter(SummaryFormatter formatter) {
        this.formatter = formatter;
        this.buffer = new StringBuilder(160);
        this.highlightPostfixPositions = new TreeMap<Integer, HighlightPostfixPosition>();
    }

    public Summarizer.Summary highlight(HighlightQueryTerms queryTerms, String field, TokenVector tokenVector, DocumentVector documentVector, Fragment[] fragments, boolean appendEllipsis) {
        Token token;
        if (this.hitIndexSorter == null || this.hitIndexSorter.size() < queryTerms.length()) {
            this.hitIndexSorter = new BitSet(queryTerms.length());
        }
        int positionToBreak = 0;
        int plainTextLength = 0;
        boolean highlightSiteOrFileExt = field.equals("url") && this.containsSizeOrFileExt(queryTerms);
        this.buffer.setLength(0);
        this.highlightPostfixPositions.clear();
        documentVector.resetOccurrenceIterator();
        if (appendEllipsis) {
            this.formatter.appendEllipsisPrefix(this.buffer);
            this.formatter.appendEllipsisPostfix(this.buffer);
        }
        int numberOfSentences = 0;
        int tokenLocation = 0;
        boolean summaryContainsText = false;
        boolean summaryContainsHighlightedTerms = false;
        int siteEndLocation = -1;
        int fileExtLocation = -1;
        if (highlightSiteOrFileExt) {
            tokenVector.setReadMode(2);
            tokenVector.begin();
            tokenLocation += tokenVector.skip(1);
            int lastTextTokenLocation = -1;
            while (fileExtLocation == -1) {
                token = tokenVector.next();
                if (token == null) {
                    if (siteEndLocation == -1) {
                        siteEndLocation = lastTextTokenLocation;
                    }
                    if (fileExtLocation != -1) break;
                    fileExtLocation = lastTextTokenLocation;
                    break;
                }
                if (TokenUtils.isTextToken(token)) {
                    lastTextTokenLocation = tokenLocation;
                }
                if (token.termText().equals("/")) {
                    siteEndLocation = tokenLocation - 1;
                }
                if (token.termText().equals("?")) {
                    fileExtLocation = tokenLocation - 1;
                }
                if (siteEndLocation != -1 && fileExtLocation != -1) break;
                tokenLocation += token.getPositionIncrement();
            }
        }
        tokenVector.setReadMode(2);
        tokenVector.begin();
        tokenLocation = 0;
        TokenVectorIterator tokenIterator = queryTerms.getTokenVectorIterator();
        tokenIterator.setTokenVector(tokenVector, true);
        for (int i = 0; i < fragments.length; ++i) {
            Fragment curFragment = fragments[i];
            tokenLocation += tokenIterator.skip(curFragment.getStartToken() - tokenLocation);
            boolean lastTokenWasPunctuation = false;
            boolean appendPeriodBeforeNextToken = false;
            int numberOfNgramTokensToSuppress = 0;
            while (tokenLocation <= curFragment.getEndToken() && (token = tokenIterator.next()) != null) {
                if (appendPeriodBeforeNextToken) {
                    int lastCharIndex = this.buffer.length() - 1;
                    while (lastCharIndex >= 0 && this.buffer.charAt(lastCharIndex) == ' ') {
                        this.buffer.deleteCharAt(lastCharIndex);
                        --lastCharIndex;
                        --plainTextLength;
                    }
                    if (this.buffer.length() < positionToBreak) {
                        positionToBreak = this.buffer.length() + 1;
                    }
                    appendPeriodBeforeNextToken = false;
                    this.buffer.append(". ");
                    plainTextLength += 2;
                }
                if (TokenUtils.isTextToken(token)) {
                    summaryContainsText = true;
                    lastTokenWasPunctuation = false;
                    this.hitIndexSorter.clear();
                    queryTerms.specialTermMatches(this.hitIndexSorter);
                    if (!queryTerms.isSpecialQuery()) {
                        int queryTermIndex = documentVector.getNextOccurrence(tokenLocation);
                        while (queryTermIndex >= 0) {
                            this.hitIndexSorter.set(queryTermIndex);
                            queryTermIndex = documentVector.getNextOccurrence(tokenLocation);
                        }
                    }
                    boolean curHitIsSingleCharacterWildcard = false;
                    if (this.hitIndexSorter.cardinality() > 0) {
                        summaryContainsHighlightedTerms = true;
                        int queryTermIndex = this.hitIndexSorter.nextSetBit(0);
                        while (queryTermIndex >= 0) {
                            WeightedTerm wt = queryTerms.getWeightedTerm(queryTermIndex);
                            if (!(highlightSiteOrFileExt && (wt.getField().equals("site") && tokenLocation > siteEndLocation || wt.getField().equals("fileext") && tokenLocation != fileExtLocation))) {
                                int termLength = wt.length();
                                int highlightEndPosition = tokenLocation + termLength - 1;
                                this.appendHighlight(queryTermIndex, highlightEndPosition);
                                if (termLength == 1) {
                                    curHitIsSingleCharacterWildcard = queryTerms.getWeightedTerm(queryTermIndex).isSingleCharacterWildcard();
                                    break;
                                }
                            }
                            queryTermIndex = this.hitIndexSorter.nextSetBit(queryTermIndex + 1);
                        }
                    }
                    if (TToken.Type.NGRAM.equals(token.type())) {
                        if (!this.highlightPostfixPositions.isEmpty() && this.highlightPostfixPositions.firstKey() == tokenLocation) {
                            char[] text = token.termText().toCharArray();
                            int length = curHitIsSingleCharacterWildcard ? 1 : text.length;
                            for (int j = numberOfNgramTokensToSuppress; j < length; ++j) {
                                if (text[j] == ' ') continue;
                                this.formatter.appendChar(this.buffer, text[j]);
                                ++plainTextLength;
                            }
                            numberOfNgramTokensToSuppress = length - 1;
                        } else if (numberOfNgramTokensToSuppress > 0) {
                            --numberOfNgramTokensToSuppress;
                        } else {
                            char c = token.termText().charAt(0);
                            if (c != ' ') {
                                this.formatter.appendChar(this.buffer, c);
                                ++plainTextLength;
                            }
                        }
                    } else {
                        String termText = token.termText();
                        this.formatter.appendString(this.buffer, termText);
                        plainTextLength += termText.length();
                    }
                    boolean addGroupPostfix = false;
                    if (!this.highlightPostfixPositions.isEmpty() && this.highlightPostfixPositions.firstKey() == tokenLocation) {
                        HighlightPostfixPosition.Iterator it = ((HighlightPostfixPosition)this.highlightPostfixPositions.remove(tokenLocation)).iterator();
                        while (it.hasNext()) {
                            this.formatter.appendHighlightPostfix(this.buffer, it.next());
                        }
                        if (this.highlightPostfixPositions.isEmpty()) {
                            addGroupPostfix = true;
                        }
                    }
                    if (addGroupPostfix) {
                        this.formatter.appendHighlightGroupPostfix(this.buffer);
                    }
                } else if (TToken.Type.PUNCTUATION.equals(token.type())) {
                    lastTokenWasPunctuation = true;
                    String termText = token.termText();
                    this.formatter.appendString(this.buffer, termText);
                    plainTextLength += termText.length();
                } else if (TToken.Type.WHITESPACE.equals(token.type())) {
                    this.buffer.append(" ");
                    ++plainTextLength;
                }
                if (TToken.Type.SENTENCE.equals(token.type())) {
                    ++numberOfSentences;
                    if (!lastTokenWasPunctuation) {
                        appendPeriodBeforeNextToken = true;
                    }
                    lastTokenWasPunctuation = false;
                }
                if (this.highlightPostfixPositions.isEmpty() && plainTextLength <= 170) {
                    positionToBreak = this.buffer.length();
                }
                tokenLocation += token.getPositionIncrement();
            }
            numberOfNgramTokensToSuppress = 0;
            if (!this.highlightPostfixPositions.isEmpty()) {
                while (!this.highlightPostfixPositions.isEmpty()) {
                    HighlightPostfixPosition.Iterator it = ((HighlightPostfixPosition)this.highlightPostfixPositions.remove(this.highlightPostfixPositions.firstKey())).iterator();
                    while (it.hasNext()) {
                        this.formatter.appendHighlightPostfix(this.buffer, it.next());
                    }
                }
                this.formatter.appendHighlightGroupPostfix(this.buffer);
                if (plainTextLength <= 170) {
                    positionToBreak = this.buffer.length();
                }
            }
            this.buffer.append(" ");
            ++plainTextLength;
            if (!appendEllipsis) continue;
            this.formatter.appendEllipsisPrefix(this.buffer);
            this.formatter.appendEllipsisPostfix(this.buffer);
        }
        if (plainTextLength <= 200) {
            positionToBreak = -1;
        }
        Summarizer.Summary summary = new Summarizer.Summary(summaryContainsText ? this.buffer.toString() : "", summaryContainsHighlightedTerms);
        summary.setShortVersionBreakPosition(positionToBreak);
        return summary;
    }

    private void appendHighlight(int queryTermIndex, int highlightEndPosition) {
        if (this.highlightPostfixPositions.isEmpty()) {
            this.formatter.appendHighlightGroupPrefix(this.buffer);
        }
        this.formatter.appendHighlightPrefix(this.buffer, queryTermIndex);
        HighlightPostfixPosition termIndexes = (HighlightPostfixPosition)this.highlightPostfixPositions.get(highlightEndPosition);
        if (termIndexes == null) {
            termIndexes = new HighlightPostfixPosition(queryTermIndex);
            this.highlightPostfixPositions.put(highlightEndPosition, termIndexes);
        } else {
            termIndexes.addTermIndex(queryTermIndex);
        }
    }

    private boolean containsSizeOrFileExt(HighlightQueryTerms terms) {
        for (int i = 0; i < terms.length(); ++i) {
            String field = terms.getWeightedTerm(i).getField();
            if (!field.equals("site") && !field.equals("fileext")) continue;
            return true;
        }
        return false;
    }

    private final class HighlightPostfixPosition {
        private int firstQueryTermIndex;
        private BitSet termIndexes = null;

        private HighlightPostfixPosition(int termIndex) {
            this.firstQueryTermIndex = termIndex;
        }

        private void addTermIndex(int termIndex) {
            if (this.termIndexes == null) {
                this.termIndexes = new BitSet(Highlighter.this.hitIndexSorter.size());
                this.termIndexes.set(this.firstQueryTermIndex);
            }
            this.termIndexes.set(termIndex);
        }

        private Iterator iterator() {
            return new Iterator();
        }

        private final class Iterator {
            private int next;

            private Iterator() {
                this.next = HighlightPostfixPosition.this.termIndexes == null ? HighlightPostfixPosition.this.firstQueryTermIndex : HighlightPostfixPosition.this.termIndexes.nextSetBit(0);
            }

            private boolean hasNext() {
                return this.next >= 0;
            }

            private int next() {
                int ret = this.next;
                this.next = HighlightPostfixPosition.this.termIndexes == null ? -1 : HighlightPostfixPosition.this.termIndexes.nextSetBit(this.next + 1);
                return ret;
            }
        }
    }
}

