/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.summarizer.fragmentbuilder;

import com.ibm.es.nuvo.search.summarizer.fragmentbuilder.Fragment;
import com.ibm.es.nuvo.search.summarizer.fragmentbuilder.FragmentFactory;
import com.ibm.es.nuvo.search.summarizer.fragmentbuilder.FragmentImpl;
import com.ibm.es.nuvo.search.summarizer.fragmentbuilder.FragmentScorer;
import java.util.ArrayList;
import java.util.BitSet;

public class FragmentPriorityQueue {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private FragmentImpl[] elements;
    private int n;
    private int capacity;
    private int numberOfQueryTerms;
    private static FragmentScorer fragmentScorer = null;
    private BitSet queryTermsInQueue;
    private BitSet intersection;
    private int numberOfNewTermsInMinFragment;
    private FragmentFactory fragmentFactory;

    private static FragmentScorer getFragmentScorer() {
        if (fragmentScorer == null) {
            fragmentScorer = new FragmentScorer();
        }
        return fragmentScorer;
    }

    public FragmentPriorityQueue(int size, int numberOfQueryTerms, FragmentFactory fragmentFactory) {
        this.elements = new FragmentImpl[size + 1];
        this.n = 0;
        this.capacity = size;
        this.numberOfQueryTerms = numberOfQueryTerms;
        this.queryTermsInQueue = new BitSet(numberOfQueryTerms);
        this.intersection = new BitSet(numberOfQueryTerms);
        this.fragmentFactory = fragmentFactory;
    }

    private int numNewTerms(BitSet b1, BitSet b2) {
        this.intersection.clear();
        this.intersection.or(b1);
        this.intersection.andNot(b2);
        return this.intersection.cardinality();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void add(FragmentImpl newElement) {
        if (this.n == 0) {
            this.elements[1] = newElement;
            this.numberOfNewTermsInMinFragment = newElement.getNumberOfUniqueQueryTerms();
            ++this.n;
            return;
        }
        if (this.n == this.capacity) {
            int compare = this.numNewTerms(newElement.getContainedQueryTerms(), this.queryTermsInQueue) - this.numberOfNewTermsInMinFragment;
            if (this.replaceIfOverlaps(newElement)) {
                return;
            }
            if (compare > 0 || compare == 0 && FragmentPriorityQueue.getFragmentScorer().compare(newElement, this.elements[1]) > 0) {
                this.fragmentFactory.releaseFragment(this.top());
                this.moveDown(newElement, 1);
                this.computeQueryTermsInQueueBitSet();
                return;
            }
            this.fragmentFactory.releaseFragment(newElement);
            return;
        }
        if (this.replaceIfOverlaps(newElement)) return;
        this.moveUp(newElement, ++this.n);
        if (newElement != this.top()) {
            this.queryTermsInQueue.or(newElement.getContainedQueryTerms());
        }
        this.computeQueryTermsInQueueBitSet();
    }

    private boolean replaceIfOverlaps(FragmentImpl newElement) {
        for (int i = 1; i <= this.n; ++i) {
            if (!this.elements[i].overlaps(newElement)) continue;
            if (FragmentPriorityQueue.getFragmentScorer().compare(this.elements[i], newElement) < 0) {
                this.intersection.clear();
                for (int j = 2; j <= this.n; ++j) {
                    if (j == i) {
                        this.intersection.or(newElement.getContainedQueryTerms());
                        continue;
                    }
                    this.intersection.or(this.elements[i].getContainedQueryTerms());
                }
                if (this.intersection.cardinality() < this.queryTermsInQueue.cardinality()) {
                    return true;
                }
                this.fragmentFactory.releaseFragment(this.elements[i]);
                this.elements[i] = newElement;
                if (!this.moveUp(newElement, i)) {
                    this.moveDown(newElement, i);
                }
                this.computeQueryTermsInQueueBitSet();
            } else {
                this.fragmentFactory.releaseFragment(newElement);
            }
            return true;
        }
        return false;
    }

    private boolean moveDown(FragmentImpl element, int k) {
        int i;
        boolean moved = false;
        while ((i = k << 1) <= this.n) {
            if (i < this.n && FragmentPriorityQueue.getFragmentScorer().compare(this.elements[i + 1], this.elements[i]) < 0) {
                ++i;
            }
            if (FragmentPriorityQueue.getFragmentScorer().compare(this.elements[i], element) >= 0) break;
            this.elements[k] = this.elements[i];
            k = i;
            moved = true;
        }
        this.elements[k] = element;
        return moved;
    }

    private boolean moveUp(FragmentImpl element, int k) {
        boolean moved = false;
        while (k > 1) {
            int i = k >> 1;
            if (FragmentPriorityQueue.getFragmentScorer().compare(element, this.elements[i]) > 0) break;
            this.elements[k] = this.elements[i];
            k = i;
            moved = true;
        }
        this.elements[k] = element;
        return moved;
    }

    public FragmentImpl removeSmallest() {
        if (this.n == 0) {
            return null;
        }
        FragmentImpl top = this.top();
        this.moveDown(this.elements[this.n--], 1);
        this.computeQueryTermsInQueueBitSet();
        return top;
    }

    private void computeQueryTermsInQueueBitSet() {
        this.queryTermsInQueue.clear();
        for (int i = 2; i <= this.n; ++i) {
            this.queryTermsInQueue.or(this.elements[i].getContainedQueryTerms());
        }
        this.numberOfNewTermsInMinFragment = this.numNewTerms(this.elements[1].getContainedQueryTerms(), this.queryTermsInQueue);
    }

    public boolean allTermsInQueue() {
        return this.n == this.capacity && this.numberOfNewTermsInMinFragment + this.queryTermsInQueue.cardinality() == this.numberOfQueryTerms;
    }

    public FragmentImpl top() {
        if (this.n == 0) {
            return null;
        }
        return this.elements[1];
    }

    public Fragment[] getFragments() {
        ArrayList<FragmentImpl> fragments = new ArrayList<FragmentImpl>();
        for (int i = 1; i <= this.n; ++i) {
            if (this.elements[i].getNumberOfUniqueQueryTerms() <= 0) continue;
            fragments.add(this.elements[i]);
        }
        if (fragments.isEmpty() && this.n > 0) {
            fragments.add(this.elements[this.n]);
        }
        return fragments.toArray(new Fragment[fragments.size()]);
    }

    public void clear(boolean releaseFragments) {
        for (int i = 1; i <= this.n; ++i) {
            if (releaseFragments) {
                this.fragmentFactory.releaseFragment(this.elements[i]);
            }
            this.elements[i] = null;
        }
        this.n = 0;
        this.numberOfNewTermsInMinFragment = 0;
        this.queryTermsInQueue.clear();
    }
}

