/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.summarizer.fragmentbuilder;

import com.ibm.es.nuvo.search.summarizer.fragmentbuilder.Fragment;
import java.util.BitSet;

class FragmentImpl
implements Fragment {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private int startToken;
    private int endToken;
    private float score;
    private int fragmentLength;
    private boolean startsWithNewSentence;
    private BitSet containedQueryTerms = new BitSet();
    private int firstHighlightStartPosition;
    private int lastHighlightEndPosition;
    private int remainingNumberOfHighlightTerms;
    private int curHighlightIndex;
    private int numberOfSentenceBreaks;
    private int numberOfUniqueTerms;

    FragmentImpl() {
        this(0, 0);
    }

    FragmentImpl(int startToken, int endToken) {
        this.reset(startToken, endToken);
    }

    void reset(int start, int end) {
        this.startToken = start;
        this.endToken = end;
        this.score = 0.0f;
        this.fragmentLength = 0;
        this.startsWithNewSentence = false;
        this.containedQueryTerms.clear();
        this.firstHighlightStartPosition = -1;
        this.lastHighlightEndPosition = 0;
        this.remainingNumberOfHighlightTerms = 0;
        this.numberOfSentenceBreaks = 0;
        this.numberOfUniqueTerms = 0;
        this.curHighlightIndex = -1;
    }

    boolean overlaps(FragmentImpl other) {
        return this.overlaps(other.startToken, other.endToken);
    }

    boolean overlaps(int otherStartToken, int otherEndToken) {
        return otherStartToken >= this.startToken && otherStartToken <= this.endToken || otherEndToken >= this.startToken && otherEndToken <= this.endToken;
    }

    public int getEndToken() {
        return this.endToken;
    }

    public int getStartToken() {
        return this.startToken;
    }

    float getScore() {
        return this.score;
    }

    int getFragmentLength() {
        return this.fragmentLength;
    }

    int getNumberOfSentenceBreaks() {
        return this.numberOfSentenceBreaks;
    }

    int getNumberOfUniqueQueryTerms() {
        return this.numberOfUniqueTerms;
    }

    BitSet getContainedQueryTerms() {
        return this.containedQueryTerms;
    }

    boolean getStartsWithNewSentence() {
        return this.startsWithNewSentence;
    }

    void addQueryTerm(int index, int termLength, float termWeight) {
        if (termLength > this.remainingNumberOfHighlightTerms) {
            this.remainingNumberOfHighlightTerms = termLength;
            if (!this.containedQueryTerms.get(index)) {
                this.curHighlightIndex = index;
            }
        }
        this.containedQueryTerms.set(index);
        this.numberOfUniqueTerms = this.containedQueryTerms.cardinality();
        this.score += termWeight;
    }

    void setScore(float score) {
        this.score = score;
    }

    void setStartToken(int startToken) {
        this.startToken = startToken;
    }

    void setEndToken(int endToken) {
        this.endToken = endToken;
    }

    void setFragmentLength(int fragmentLength) {
        this.fragmentLength = fragmentLength;
    }

    void setNumberOfSentenceBreaks(int numberOfSentenceBreaks) {
        this.numberOfSentenceBreaks = numberOfSentenceBreaks;
    }

    void setStartsWithNewSentence(boolean startsWithNewSentence) {
        this.startsWithNewSentence = startsWithNewSentence;
    }

    public String toString() {
        return "FRAGMENT[" + this.startToken + ", " + this.endToken + ", " + this.score + "]";
    }

    int getFirstHighlightStartPosition() {
        return this.firstHighlightStartPosition;
    }

    void setFirstHighlightStartPosition(int firstHighlightStartPosition) {
        this.firstHighlightStartPosition = firstHighlightStartPosition;
    }

    int getLastHighlightEndPosition() {
        return this.lastHighlightEndPosition;
    }

    void setLastHighlightEndPosition(int lastHighlightEndPosition) {
        this.lastHighlightEndPosition = lastHighlightEndPosition;
    }

    int getRemainingNumberOfHighlightTerms() {
        return this.remainingNumberOfHighlightTerms;
    }

    void finish() {
        if (this.remainingNumberOfHighlightTerms > 0 && this.curHighlightIndex != -1) {
            this.containedQueryTerms.clear(this.curHighlightIndex);
            --this.numberOfUniqueTerms;
        }
        this.curHighlightIndex = -1;
    }

    void decrementRemainingNumberOfHighlightTerms() {
        --this.remainingNumberOfHighlightTerms;
    }
}

