/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.summarizer.fragmentbuilder;

import com.ibm.es.nuvo.search.summarizer.documentvectorizer.DocumentVector;
import com.ibm.es.nuvo.search.summarizer.fragmentbuilder.Fragment;
import com.ibm.es.nuvo.search.summarizer.fragmentbuilder.FragmentFactory;
import com.ibm.es.nuvo.search.summarizer.fragmentbuilder.FragmentImpl;
import com.ibm.es.nuvo.search.summarizer.fragmentbuilder.FragmentPriorityQueue;
import com.ibm.es.nuvo.search.summarizer.queryterms.HighlightQueryTerms;
import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.es.nuvo.tokenizer.TokenVector;
import com.ibm.es.nuvo.tokenizer.TokenVectorIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;

public class FragmentBuilder {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private FragmentFactory fragmentFactory;
    private List<FragmentImpl> candidates;

    public FragmentBuilder(FragmentFactory fragmentFactory) {
        this.fragmentFactory = fragmentFactory;
        this.candidates = new ArrayList<FragmentImpl>();
    }

    public Fragment[] buildFragments(HighlightQueryTerms queryTerms, TokenVector tokenVector, DocumentVector documentVector, int numFragments, int maxFragmentLength) {
        boolean queryQualifiesForSingleFragment = queryTerms.getNumberOfNormalTerms() > 1 || queryTerms.getNumberOfNormalTerms() == 1 && queryTerms.getWeightedTerm(0).length() > 1;
        FragmentPriorityQueue fragmentQueue = new FragmentPriorityQueue(numFragments, queryTerms.length(), this.fragmentFactory);
        this.candidates.clear();
        documentVector.resetOccurrenceIterator();
        tokenVector.begin();
        TokenVectorIterator tokenIterator = tokenVector.iterator(TokenVectorIterator.Mode.SUMMARY);
        int fragmentStartGap = 5;
        int maxNumCharsBeforeFinish = 500;
        int skip = 0;
        int lastStartToken = 0;
        int curToken = 0;
        int deltaLength = 0;
        int numCharsBeforeFinish = -1;
        BitSet occAtCurPos = new BitSet(queryTerms.length());
        while (tokenIterator.next()) {
            boolean newSentence;
            TToken.Type curType = tokenIterator.getType();
            boolean bl = newSentence = TToken.Type.SENTENCE == curType;
            if (newSentence) {
                if (skip > 0) {
                    skip = Math.max(0, skip - tokenIterator.getPosition() + curToken);
                }
                curToken = tokenIterator.getPosition();
                for (int i = this.candidates.size() - 1; i >= 0; --i) {
                    FragmentImpl curCandidate = this.candidates.get(i);
                    curCandidate.setNumberOfSentenceBreaks(1 + curCandidate.getNumberOfSentenceBreaks());
                    if (curCandidate.getStartToken() <= 0 || curCandidate.getNumberOfUniqueQueryTerms() != 0) continue;
                    this.fragmentFactory.releaseFragment(this.candidates.remove(i));
                }
            }
            if ((curToken == 0 || newSentence || curToken >= lastStartToken + 5) && skip == 0) {
                lastStartToken = curToken;
                FragmentImpl newFrag = this.fragmentFactory.getFragment(curToken, curToken);
                newFrag.setStartsWithNewSentence(newSentence);
                this.candidates.add(newFrag);
            }
            if (!newSentence) {
                occAtCurPos.clear();
                boolean isTextToken = TToken.Type.ORIGINAL == curType || TToken.Type.BOTH == curType || TToken.Type.NGRAM == curType;
                deltaLength += tokenIterator.length();
                if (isTextToken) {
                    int nextOccPos;
                    int occIndex = documentVector.getNextOccurrence(curToken);
                    while (occIndex >= 0) {
                        occAtCurPos.set(occIndex);
                        occIndex = documentVector.getNextOccurrence(curToken);
                    }
                    if (skip == 0 && (nextOccPos = documentVector.getNextOccurrencePosition()) != -1 && nextOccPos > curToken + maxFragmentLength) {
                        skip = nextOccPos - curToken - maxFragmentLength;
                    }
                    for (int i = 0; i < this.candidates.size(); ++i) {
                        FragmentImpl curCandidate = this.candidates.get(i);
                        int newLength = curCandidate.getFragmentLength() + deltaLength;
                        if (queryQualifiesForSingleFragment && curCandidate.getNumberOfUniqueQueryTerms() == queryTerms.getNumberOfNormalTerms() && curCandidate.getRemainingNumberOfHighlightTerms() == 0) {
                            float avgSentenceLength;
                            float f = avgSentenceLength = curCandidate.getNumberOfSentenceBreaks() > 0 ? (float)curCandidate.getFragmentLength() / (float)curCandidate.getNumberOfSentenceBreaks() : (float)curCandidate.getFragmentLength();
                            if (avgSentenceLength > (float)(maxFragmentLength / 3)) {
                                curCandidate.setEndToken(curToken);
                                curCandidate.setFragmentLength(newLength);
                                fragmentQueue.clear(true);
                                return this.createSingleFragment(tokenIterator, curCandidate, numFragments * maxFragmentLength);
                            }
                        }
                        if (newLength > maxFragmentLength) {
                            this.boostFragmentScore(curCandidate, queryTerms.getMinWeight());
                            curCandidate.finish();
                            this.candidates.remove(i--);
                            fragmentQueue.add(curCandidate);
                            if (!fragmentQueue.allTermsInQueue() || numCharsBeforeFinish >= 0) continue;
                            numCharsBeforeFinish = 500;
                            continue;
                        }
                        curCandidate.setEndToken(curToken);
                        if (!occAtCurPos.isEmpty()) {
                            int occIndex2 = occAtCurPos.nextSetBit(0);
                            while (occIndex2 >= 0) {
                                curCandidate.addQueryTerm(occIndex2, queryTerms.getWeightedTerm(occIndex2).length(), queryTerms.getWeightedTerm(occIndex2).getWeight());
                                occIndex2 = occAtCurPos.nextSetBit(occIndex2 + 1);
                            }
                            if (curCandidate.getFirstHighlightStartPosition() == -1) {
                                curCandidate.setFirstHighlightStartPosition(curCandidate.getFragmentLength() + 1);
                            }
                        }
                        if (curCandidate.getRemainingNumberOfHighlightTerms() > 0) {
                            curCandidate.decrementRemainingNumberOfHighlightTerms();
                            curCandidate.setLastHighlightEndPosition(newLength);
                        }
                        curCandidate.setFragmentLength(newLength);
                    }
                    deltaLength = 0;
                }
                if (skip > 0) {
                    skip = Math.max(0, skip - tokenIterator.getPosition() + curToken);
                }
                curToken = tokenIterator.getPosition();
                if (numCharsBeforeFinish > 0) {
                    numCharsBeforeFinish = Math.max(0, numCharsBeforeFinish - tokenIterator.length());
                }
            }
            if (numCharsBeforeFinish == 0) break;
            if (skip <= 0 || !this.candidates.isEmpty()) continue;
            curToken += tokenIterator.skip(skip);
            lastStartToken = 0;
            skip = 0;
        }
        if (!this.candidates.isEmpty()) {
            for (FragmentImpl curCandidate : this.candidates) {
                this.boostFragmentScore(curCandidate, queryTerms.getMinWeight());
                fragmentQueue.add(curCandidate);
            }
        }
        this.candidates.clear();
        Fragment[] fragments = fragmentQueue.getFragments();
        Arrays.sort(fragments, new Comparator<Fragment>(){

            @Override
            public int compare(Fragment f1, Fragment f2) {
                return f1.getStartToken() - f2.getStartToken();
            }
        });
        fragmentQueue.clear(false);
        return fragments;
    }

    private Fragment[] createSingleFragment(TokenVectorIterator tokenIterator, FragmentImpl fragment, int maxLength) {
        int newLength;
        while (tokenIterator.next() && (newLength = fragment.getFragmentLength() + tokenIterator.length()) <= maxLength) {
            fragment.setFragmentLength(newLength);
            fragment.setEndToken(tokenIterator.getPosition());
        }
        return new Fragment[]{fragment};
    }

    private void boostFragmentScore(FragmentImpl f, float minQueryTermWeight) {
        if (f.getFirstHighlightStartPosition() == -1) {
            return;
        }
        float boost = 0.0f;
        if (f.getStartsWithNewSentence()) {
            boost = 1.0f;
        }
        int numBoundaryTokens = Math.abs(f.getFirstHighlightStartPosition() + f.getLastHighlightEndPosition() - f.getFragmentLength());
        boost += (float)(f.getFragmentLength() - numBoundaryTokens) / (float)f.getFragmentLength();
        f.setScore((boost *= minQueryTermWeight) + f.getScore());
    }

    public void releaseFragments(Fragment[] fragments) {
        for (int i = 0; i < fragments.length; ++i) {
            this.fragmentFactory.releaseFragment((FragmentImpl)fragments[i]);
        }
    }
}

